<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cases_Featured extends AI_Widget_Base {
    public function get_name() { return 'ai_cases_featured'; }
    public function get_title() { return __('Cases Featured', 'ai-theme'); }
    public function get_icon() { return 'eicon-posts-carousel'; }
    public function get_categories() { return array('ai-theme-cases'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('client', ['label' => __('Client', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('industry', ['label' => __('Industry', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('results', ['label' => __('Results (one per line)', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('link', ['label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL]);

        $this->add_control('cases', ['label' => __('Cases', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $cases = $s['cases'] ?? [];
        $featured = !empty($cases) ? $cases[0] : null;
        $others = array_slice($cases, 1, 3);
        ?>
        <section class="section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cases" data-block-variant="cases-featured">
            <div class="max-w-7xl mx-auto px-6">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)]"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <?php if ($featured) :
                    $results = !empty($featured['results']) ? array_filter(explode("\n", $featured['results'])) : [];
                ?>
                <!-- Featured Case -->
                <div class="bg-[var(--bg-primary)] rounded-3xl overflow-hidden shadow-xl mb-8">
                    <div class="grid lg:grid-cols-2">
                        <?php if (!empty($featured['image']['url'])) : ?>
                        <div class="relative h-80 lg:h-auto">
                            <img src="<?php echo esc_url($featured['image']['url']); ?>" alt="<?php echo esc_attr($featured['title']); ?>" class="w-full h-full object-cover">
                            <?php if (!empty($featured['industry'])) : ?>
                            <div class="absolute top-4 left-4 bg-[var(--primary)] text-white px-4 py-2 rounded-full text-sm font-semibold">
                                <?php echo esc_html($featured['industry']); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        <div class="p-8 lg:p-12 flex flex-col justify-center">
                            <h3 class="text-3xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($featured['title']); ?></h3>
                            <?php if (!empty($featured['client'])) : ?>
                            <p class="text-[var(--primary)] font-semibold mb-4"><?php echo esc_html($featured['client']); ?></p>
                            <?php endif; ?>
                            <?php if (!empty($featured['description'])) : ?>
                            <p class="text-[var(--text-secondary)] mb-6"><?php echo esc_html($featured['description']); ?></p>
                            <?php endif; ?>
                            <?php if (!empty($results)) : ?>
                            <div class="flex flex-wrap gap-2 mb-6">
                                <?php foreach ($results as $result) : ?>
                                <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-sm font-medium"><?php echo esc_html(trim($result)); ?></span>
                                <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                            <?php if (!empty($featured['link']['url'])) : ?>
                            <a href="<?php echo esc_url($featured['link']['url']); ?>" class="inline-flex items-center gap-2 text-[var(--primary)] font-semibold hover:gap-3 transition-all">
                                <?php echo ai_get_text('cases.readFullCase', __('Read full case', 'ai-theme')); ?>
                                <span class="text-xl">→</span>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (!empty($others)) : ?>
                <!-- Other Cases -->
                <div class="grid md:grid-cols-3 gap-6">
                    <?php foreach ($others as $case) : ?>
                    <div class="bg-[var(--bg-primary)] rounded-2xl overflow-hidden shadow-lg hover:shadow-xl transition-shadow">
                        <?php if (!empty($case['image']['url'])) : ?>
                        <img src="<?php echo esc_url($case['image']['url']); ?>" alt="<?php echo esc_attr($case['title']); ?>" class="w-full h-48 object-cover">
                        <?php endif; ?>
                        <div class="p-6">
                            <?php if (!empty($case['industry'])) : ?>
                            <span class="text-xs text-[var(--text-muted)] uppercase tracking-wide"><?php echo esc_html($case['industry']); ?></span>
                            <?php endif; ?>
                            <h4 class="text-xl font-bold text-[var(--text-primary)] mt-1 mb-2"><?php echo esc_html($case['title']); ?></h4>
                            <?php if (!empty($case['client'])) : ?>
                            <p class="text-sm text-[var(--primary)]"><?php echo esc_html($case['client']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
