<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Categories_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_categories_cards'; }
    public function get_title() { return __('Categories Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-folder'; }
    public function get_categories() { return array('ai-theme-categories'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('use_woocommerce', array('label' => __('Use WooCommerce Categories', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->add_control('count', array('label' => __('Count', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 6));
        $this->add_control('columns', array('label' => __('Columns', 'ai-theme'), 'type' => Controls_Manager::SELECT, 'default' => '3', 'options' => ['2' => '2', '3' => '3', '4' => '4']));
        $this->add_control('show_count', array('label' => __('Show Product Count', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        
        if ($settings['use_woocommerce'] === 'yes' && class_exists('WooCommerce')) {
            $categories = get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false, 'number' => intval($settings['count'])));
        } else {
            $categories = get_categories(array('number' => intval($settings['count'])));
        }

        $cols = intval($settings['columns']);
        $grid_class = 'grid-cols-1 md:grid-cols-2';
        if ($cols === 3) $grid_class = 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3';
        if ($cols === 4) $grid_class = 'grid-cols-1 md:grid-cols-2 lg:grid-cols-4';
        ?>
        <section class="relative py-20 md:py-28 overflow-hidden section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="categories" data-block-variant="categories-cards">
            <!-- Gradient Mesh Background -->
            <div class="absolute inset-0 bg-gradient-to-br from-[var(--bg-tertiary)] via-[var(--bg-secondary)] to-[var(--bg-tertiary)]">
                <div class="absolute top-0 left-1/4 w-96 h-96 bg-[var(--primary)]/20 rounded-full blur-[128px]"></div>
                <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-[var(--secondary)]/20 rounded-full blur-[128px]"></div>
                <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-96 h-96 bg-[var(--accent)]/15 rounded-full blur-[128px]"></div>
            </div>

            <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="text-center mb-16">
                    <?php if (!empty($settings['subheading'])) : ?>
                    <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-[var(--primary)]/10 backdrop-blur-sm border border-[var(--border-color)] mb-6">
                        <svg class="w-4 h-4 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"></path>
                        </svg>
                        <span class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($settings['subheading']); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-4xl md:text-5xl lg:text-6xl font-bold text-[var(--text-primary)]"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Cards Grid -->
                <div class="grid <?php echo esc_attr($grid_class); ?> gap-6">
                    <?php foreach ($categories as $cat) : 
                        $link = get_term_link($cat);
                        $thumb_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
                        $image = $thumb_id ? wp_get_attachment_image_url($thumb_id, 'large') : '';
                        $description = $cat->description ?? '';
                    ?>
                    <a href="<?php echo esc_url($link); ?>" class="group relative">
                        <!-- Card -->
                        <div class="relative h-80 rounded-2xl overflow-hidden bg-[var(--bg-primary)]/10 backdrop-blur-md border border-[var(--border-color)] p-6 flex flex-col justify-end transition-all duration-500 group-hover:bg-[var(--bg-primary)]/15 group-hover:border-[var(--primary)]/30 group-hover:scale-[1.02]">
                            <!-- Background Image -->
                            <?php if ($image) : ?>
                            <div class="absolute inset-0">
                                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($cat->name); ?>" class="w-full h-full object-cover opacity-40 group-hover:opacity-50 group-hover:scale-110 transition-all duration-700" />
                                <div class="absolute inset-0 bg-gradient-to-t from-[var(--bg-dark)]/80 via-[var(--bg-dark)]/40 to-transparent"></div>
                            </div>
                            <?php endif; ?>

                            <!-- Content -->
                            <div class="relative z-10">
                                <?php if ($settings['show_count'] === 'yes') : ?>
                                <div class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full bg-[var(--bg-primary)]/20 backdrop-blur-sm text-xs text-[var(--text-primary)]/80 mb-4">
                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                    </svg>
                                    <?php echo $cat->count; ?> <?php _e('products', 'ai-theme'); ?>
                                </div>
                                <?php endif; ?>

                                <h3 class="text-2xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($cat->name); ?></h3>

                                <?php if ($description) : ?>
                                <p class="text-[var(--text-secondary)] text-sm mb-4 line-clamp-2"><?php echo esc_html($description); ?></p>
                                <?php endif; ?>

                                <div class="flex items-center gap-2 text-[var(--primary)] text-sm font-medium opacity-0 transform translate-y-2 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                                    <span><?php _e('View', 'ai-theme'); ?></span>
                                    <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </div>
                            </div>

                            <!-- Glow Effect -->
                            <div class="absolute inset-0 rounded-2xl bg-gradient-to-r from-[var(--primary)]/0 via-[var(--primary)]/0 to-[var(--secondary)]/0 opacity-0 group-hover:opacity-20 transition-opacity duration-500"></div>
                        </div>
                    </a>
                    <?php endforeach; ?>
                </div>

                <!-- Empty State -->
                <?php if (empty($categories)) : ?>
                <div class="text-center py-20">
                    <svg class="w-16 h-16 text-[var(--text-muted)] mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                    <p class="text-[var(--text-muted)]"><?php _e('No categories found', 'ai-theme'); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
