<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Contact_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_contact_cards'; }
    public function get_title() { return __('Contact Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-call-to-action'; }
    public function get_categories() { return array('ai-theme-contact'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subtitle', array('label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('type', array('label' => __('Type', 'ai-theme'), 'type' => Controls_Manager::SELECT, 'default' => 'email', 'options' => array('email' => 'Email', 'phone' => 'Phone', 'address' => 'Address', 'other' => 'Other')));
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('value', array('label' => __('Value', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('link', array('label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL));

        $this->add_control('contacts', array('label' => __('Contact Info', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        if (empty($settings['contacts'])) return;

        // Use settings first, fallback to ai_get_text for backwards compatibility
        $subheading = !empty($settings['subtitle'])
            ? $settings['subtitle']
            : ai_get_text('blocks.contact.subheading', '');
        ?>
        <section class="py-20 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="contact" data-block-variant="contact-cards">
            <div class="max-w-4xl mx-auto px-6">
                <!-- Header -->
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($settings['heading']); ?></h2>
                    <p class="text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($subheading); ?></p>
                </div>

                <!-- Cards Grid -->
                <div class="grid sm:grid-cols-3 gap-6">
                    <?php foreach ($settings['contacts'] as $index => $contact) :
                        $hasLink = !empty($contact['link']['url']);
                        $tag = $hasLink ? 'a' : 'div';
                        $href = $hasLink ? ' href="' . esc_url($contact['link']['url']) . '"' : '';
                        $hoverClass = $hasLink ? 'hover:bg-[var(--bg-primary)]' : '';
                    ?>
                        <<?php echo $tag . $href; ?> class="bg-[var(--bg-secondary)] <?php echo $hoverClass; ?> p-6 rounded-2xl text-center transition-colors">
                            <div class="w-14 h-14 bg-[var(--primary-light)] rounded-xl flex items-center justify-center mx-auto mb-4">
                                <?php echo $this->get_contact_icon($contact['type'], 'text-[var(--primary)]'); ?>
                            </div>
                            <h3 class="font-semibold text-[var(--text-primary)] mb-2"><?php echo esc_html($contact['title']); ?></h3>
                            <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($contact['value']); ?></p>
                        </<?php echo $tag; ?>>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }

    private function get_color_classes($type) {
        $colors = array(
            'email' => array('bg' => 'bg-blue-50', 'icon' => 'text-blue-600'),
            'phone' => array('bg' => 'bg-green-50', 'icon' => 'text-green-600'),
            'address' => array('bg' => 'bg-purple-50', 'icon' => 'text-purple-600'),
            'other' => array('bg' => 'bg-[var(--bg-secondary)]', 'icon' => 'text-[var(--text-secondary)]'),
        );
        return $colors[$type] ?? $colors['other'];
    }

    private function get_contact_icon($type, $colorClass = 'text-blue-600') {
        $icons = array(
            'email' => '<svg class="w-6 h-6 ' . $colorClass . '" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>',
            'phone' => '<svg class="w-6 h-6 ' . $colorClass . '" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>',
            'address' => '<svg class="w-6 h-6 ' . $colorClass . '" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>',
        );
        return $icons[$type] ?? $icons['email'];
    }
}
