<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cookies_Accordion extends AI_Widget_Base {
    public function get_name() { return 'ai_cookies_accordion'; }
    public function get_title() { return __('Cookies Accordion', 'ai-theme'); }
    public function get_icon() { return 'eicon-info-circle'; }
    public function get_categories() { return array('ai-theme-cookies'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('last_updated', array('label' => __('Last Updated', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('introduction', array('label' => __('Introduction', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('contact_email', array('label' => __('Contact Email', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('content', array('label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG, 'default' => ''));

        $this->add_control('sections', array('label' => __('Sections', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();

        // Cookie Types
        $this->start_controls_section('cookies_section', array('label' => __('Cookie Types', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));

        $cookie_repeater = new Repeater();
        $cookie_repeater->add_control('name', array('label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $cookie_repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $cookie_repeater->add_control('required', array('label' => __('Required', 'ai-theme'), 'type' => Controls_Manager::SWITCHER));

        $this->add_control('cookie_types', array('label' => __('Cookie Types', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $cookie_repeater->get_controls()));
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $widget_id = $this->get_id();

        // Use AI-generated texts with fallbacks
        $t = [
            'updated' => ai_get_text('legal.cookies.lastUpdated', 'Updated'),
            'cookieTypes' => ai_get_text('legal.cookies.typesTitle', 'Cookie Types'),
            'required' => ai_get_text('common.required', 'Required'),
            'optional' => ai_get_text('common.optional', 'Optional'),
            'contactTitle' => ai_get_text('legal.cookies.contactTitle', 'Questions?'),
        ];
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cookies" data-block-variant="cookies-accordion">
            <div class="max-w-3xl mx-auto px-4 sm:px-6">
                <!-- Header -->
                <div class="text-center mb-10">
                    <div class="w-14 h-14 bg-gradient-to-br from-amber-400 to-orange-500 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h1 class="text-3xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($s['heading']); ?></h1>
                    <?php if (!empty($s['last_updated'])) : ?>
                    <p class="text-sm text-[var(--text-muted)]"><?php echo esc_html($t['updated']); ?>: <?php echo esc_html($s['last_updated']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Introduction -->
                <?php if (!empty($s['introduction'])) : ?>
                <div class="bg-gradient-to-r from-amber-50 to-orange-50 rounded-2xl p-6 mb-8 border border-amber-100">
                    <p class="text-[var(--text-secondary)]"><?php echo esc_html($s['introduction']); ?></p>
                </div>
                <?php endif; ?>

                <!-- Accordion Sections -->
                <?php if (!empty($s['sections'])) : ?>
                <div class="space-y-3 mb-8">
                    <?php foreach ($s['sections'] as $idx => $section) : ?>
                    <div class="border border-[var(--border-color)] rounded-xl overflow-hidden">
                        <button class="cookies-acc-btn w-full px-5 py-4 text-left flex items-center justify-between bg-[var(--bg-primary)] hover:bg-[var(--bg-secondary)] transition-colors" data-target="cookies-acc-<?php echo esc_attr($widget_id . '-' . $idx); ?>">
                            <span class="font-semibold text-[var(--text-primary)]"><?php echo ($idx + 1) . '. ' . esc_html($section['title']); ?></span>
                            <svg class="w-5 h-5 text-[var(--text-secondary)] cookies-acc-icon transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div id="cookies-acc-<?php echo esc_attr($widget_id . '-' . $idx); ?>" class="cookies-acc-content hidden px-5 py-4 bg-[var(--bg-secondary)] border-t border-[var(--border-color)]">
                            <div class="prose prose-sm max-w-none text-[var(--text-secondary)]">
                                <?php echo wp_kses_post($section['content']); ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <!-- Cookie Types -->
                <?php if (!empty($s['cookie_types'])) : ?>
                <div class="space-y-3">
                    <h2 class="text-lg font-semibold text-[var(--text-primary)] mb-4"><?php echo esc_html($t['cookieTypes']); ?></h2>
                    <?php foreach ($s['cookie_types'] as $cookie) : 
                        $is_required = !empty($cookie['required']) && $cookie['required'] === 'yes';
                    ?>
                    <div class="border border-[var(--border-color)] rounded-xl p-4 hover:shadow-sm transition-shadow">
                        <div class="flex items-start justify-between">
                            <div>
                                <h3 class="font-semibold text-[var(--text-primary)]"><?php echo esc_html($cookie['name']); ?></h3>
                                <p class="text-sm text-[var(--text-secondary)] mt-1"><?php echo esc_html($cookie['description']); ?></p>
                            </div>
                            <span class="text-xs px-3 py-1 rounded-full font-medium flex-shrink-0 ml-4 <?php echo $is_required ? 'bg-[var(--bg-secondary)] text-[var(--text-secondary)]' : 'bg-green-100 text-green-700'; ?>">
                                <?php echo esc_html($is_required ? $t['required'] : $t['optional']); ?>
                            </span>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <!-- Contact -->
                <?php if (!empty($s['contact_email'])) : ?>
                <div class="mt-10 text-center">
                    <p class="text-[var(--text-secondary)]">
                        <?php echo esc_html($t['contactTitle']); ?> <a href="mailto:<?php echo esc_attr($s['contact_email']); ?>" class="text-amber-600 hover:text-amber-700 font-medium"><?php echo esc_html($s['contact_email']); ?></a>
                    </p>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <script>
        document.querySelectorAll('.cookies-acc-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                const content = document.getElementById(btn.dataset.target);
                const icon = btn.querySelector('.cookies-acc-icon');
                content.classList.toggle('hidden');
                icon.style.transform = content.classList.contains('hidden') ? '' : 'rotate(180deg)';
            });
        });
        </script>
        <?php
    }
}
