<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cookies_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_cookies_minimal'; }
    public function get_title() { return __('Cookies Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-info-circle'; }
    public function get_categories() { return array('ai-theme-cookies'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('last_updated', array('label' => __('Last Updated', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('introduction', array('label' => __('Introduction', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('contact_email', array('label' => __('Contact Email', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('content', array('label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));

        $this->add_control('sections', array('label' => __('Sections', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');

        // Use AI-generated texts with fallbacks
        $t = [
            'updated' => ai_get_text('legal.cookies.lastUpdated', 'Updated'),
            'contactTitle' => ai_get_text('legal.cookies.contactTitle', 'Questions? Contact us'),
        ];
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cookies" data-block-variant="cookies-minimal">
            <div class="max-w-3xl mx-auto px-4 sm:px-6">
                <!-- Header -->
                <div class="mb-10">
                    <h1 class="text-3xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($s['heading']); ?></h1>
                    <?php if (!empty($s['last_updated'])) : ?>
                    <p class="text-sm text-[var(--text-muted)]"><?php echo esc_html($t['updated']); ?>: <?php echo esc_html($s['last_updated']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Introduction -->
                <?php if (!empty($s['introduction'])) : ?>
                <p class="text-[var(--text-secondary)] leading-relaxed mb-8 pb-8 border-b border-[var(--border-color)]">
                    <?php echo esc_html($s['introduction']); ?>
                </p>
                <?php endif; ?>

                <!-- Sections -->
                <div class="space-y-8">
                    <?php foreach ($s['sections'] as $idx => $section) : ?>
                    <div class="border-b border-[var(--border-color)] pb-8 last:border-0">
                        <h2 class="text-xl font-semibold text-[var(--text-primary)] mb-3">
                            <?php echo ($idx + 1) . '. ' . esc_html($section['title']); ?>
                        </h2>
                        <p class="text-[var(--text-secondary)] leading-relaxed"><?php echo esc_html($section['content']); ?></p>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Contact -->
                <?php if (!empty($s['contact_email'])) : ?>
                <div class="mt-10 p-6 bg-[var(--bg-secondary)] rounded-xl">
                    <p class="text-[var(--text-secondary)] mb-2"><?php echo esc_html($t['contactTitle']); ?>:</p>
                    <a href="mailto:<?php echo esc_attr($s['contact_email']); ?>" class="text-amber-600 hover:text-amber-700 font-medium">
                        <?php echo esc_html($s['contact_email']); ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
