<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class CTA_Box extends AI_Widget_Base {
    public function get_name() { return 'ai_cta_box'; }
    public function get_title() { return __('CTA Box', 'ai-theme'); }
    public function get_icon() { return 'eicon-call-to-action'; }
    public function get_categories() { return array('ai-theme-cta'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('button_link', ['label' => __('Button Link', 'ai-theme'), 'type' => Controls_Manager::URL]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $buttonText = !empty($s['button_text']) ? $s['button_text'] : ai_get_text('cta.buttonText', '');
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <div data-theme="<?php echo esc_attr($theme); ?>" class="ai-theme-block">
            <section class="ai-cta ai-cta-box py-16 section-secondary" data-block-type="cta" data-block-variant="cta-box">
                <div class="ai-container-narrow">
                    <div class="ai-cta-box-inner bg-[var(--bg-secondary)] border border-[var(--border-color)] rounded-2xl p-12 text-center">
                        <h2 class="cta-heading text-4xl mb-4 text-[var(--text-primary)]"><?php echo esc_html($s['title']); ?></h2>
                        <?php if (!empty($s['description'])) : ?><p class="cta-description text-lg text-[var(--text-secondary)] mb-8"><?php echo esc_html($s['description']); ?></p><?php endif; ?>
                        <a href="<?php echo esc_url($s['button_link']['url'] ?? '#'); ?>" class="ai-cta-button inline-block bg-[var(--primary)] text-[var(--text-on-primary)] px-8 py-3 rounded-xl font-semibold hover:shadow-lg transition-shadow"><?php echo esc_html($buttonText); ?></a>
                    </div>
                </div>
            </section>
        </div>
        <?php
    }
}
