<?php
/**
 * CTA Centered Widget
 *
 * @package AI_Theme
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * CTA Centered Widget
 */
class CTA_Centered extends AI_Widget_Base {

    public function get_name() {
        return 'ai_cta_centered';
    }

    public function get_title() {
        return __('CTA Centered', 'ai-theme');
    }

    public function get_icon() {
        return 'eicon-call-to-action';
    }

    public function get_categories() {
        return array('ai-theme-blocks');
    }

    public function get_keywords() {
        return array('cta', 'call to action', 'button', 'ai');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'ai-theme'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'heading',
            array(
                'label'       => __('Heading', 'ai-theme'),
                'type'        => Controls_Manager::TEXT,
                'default'     => '',
                'label_block' => true,
            )
        );

        $this->add_control(
            'description',
            array(
                'label'   => __('Description', 'ai-theme'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => '',
            )
        );

        $this->add_control(
            'button_text',
            array(
                'label'   => __('Button Text', 'ai-theme'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            )
        );

        $this->add_control(
            'button_link',
            array(
                'label'       => __('Button Link', 'ai-theme'),
                'type'        => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'ai-theme'),
                'default'     => array(
                    'url' => '#',
                ),
            )
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $buttonText = !empty($settings['button_text']) ? $settings['button_text'] : ai_get_text('cta.buttonText', '');
        $heading = !empty($settings['heading']) ? $settings['heading'] : ai_get_text('blocks.cta.heading', '');
        $description = !empty($settings['description']) ? $settings['description'] : ai_get_text('blocks.cta.description', '');
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <div data-theme="<?php echo esc_attr($theme); ?>" class="ai-theme-block">
            <section class="ai-cta-centered py-20 bg-[var(--bg-secondary)]" data-block-type="cta" data-block-variant="cta-centered">
                <div class="ai-container-narrow text-center">
                    <h2 class="cta-heading text-5xl mb-6 text-[var(--text-primary)]"><?php echo esc_html($heading); ?></h2>
                    <?php if (!empty($description)) : ?>
                        <p class="cta-description text-xl mb-8 text-[var(--text-secondary)]"><?php echo esc_html($description); ?></p>
                    <?php endif; ?>
                    <a href="<?php echo esc_url($settings['button_link']['url']); ?>" class="ai-cta-button inline-flex items-center gap-2 px-10 py-4 text-lg shadow-lg hover:scale-105 bg-[var(--primary)] text-[var(--text-on-primary)] rounded-lg">
                        <?php echo esc_html($buttonText); ?>
                        <span class="text-xl">→</span>
                    </a>
                </div>
            </section>
        </div>
        <?php
    }
}
