<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class FAQ_Accordion extends AI_Widget_Base {
    public function get_name() { return 'ai_faq_accordion'; }
    public function get_title() { return __('FAQ Accordion', 'ai-theme'); }
    public function get_icon() { return 'eicon-accordion'; }
    public function get_categories() { return array('ai-theme-faq'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('question', ['label' => __('Question', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('answer', ['label' => __('Answer', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('faqs', ['label' => __('FAQ Items', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-faq ai-faq-accordion section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="faq" data-block-variant="faq-accordion">
            <div class="max-w-3xl mx-auto px-6">
                <h2 class="ai-faq-title text-4xl font-bold text-[var(--text-primary)] text-center mb-12"><?php echo esc_html($s['title']); ?></h2>
                <div class="ai-faq-items space-y-4">
                    <?php foreach ($s['faqs'] as $i => $f) : ?>
                    <div class="ai-faq-item bg-[var(--bg-primary)] rounded-xl border border-[var(--border-color,#e5e7eb)] overflow-hidden" data-faq-item>
                        <button class="ai-faq-question w-full px-6 py-4 text-left font-semibold text-[var(--text-primary)] hover:bg-[var(--bg-secondary)] flex justify-between items-center cursor-pointer" aria-expanded="false" data-faq-question>
                            <?php echo esc_html($f['question']); ?>
                            <svg class="w-5 h-5 text-[var(--text-muted)] transition-transform" data-faq-icon fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                        </button>
                        <div class="ai-faq-answer px-6 pb-4" data-faq-answer>
                            <div class="text-[var(--text-secondary)] prose prose-sm max-w-none"><?php echo wp_kses_post($f['answer']); ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
