<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Features_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_features_minimal'; }
    public function get_title() { return __('Features Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-check-circle'; }
    public function get_categories() { return array('ai-theme-features'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'label_block' => true]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'rows' => 2]);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('features', ['label' => __('Features', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-features ai-features-minimal py-20 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="features" data-block-variant="features-minimal">
            <div class="max-w-6xl mx-auto px-6">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-16 items-start">
                    <!-- Left side - heading -->
                    <div>
                        <?php if (!empty($s['title'])) : ?>
                            <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($s['subheading'])) : ?>
                            <p class="text-lg text-[var(--text-secondary)]"><?php echo esc_html($s['subheading']); ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Right side - checklist -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <?php foreach ($s['features'] as $f) : ?>
                        <div class="flex items-start gap-3 p-4 rounded-lg hover:bg-[var(--bg-secondary)] transition-colors">
                            <div class="flex-shrink-0 w-6 h-6 rounded-full bg-[var(--primary-light)] flex items-center justify-center mt-0.5">
                                <svg class="w-4 h-4 text-[var(--primary)]" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-semibold text-[var(--text-primary)]"><?php echo esc_html($f['title']); ?></h3>
                                <p class="text-sm text-[var(--text-muted)] mt-1"><?php echo esc_html($f['description']); ?></p>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
