<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Gallery_Grid3 extends AI_Widget_Base {
    public function get_name() { return 'ai_gallery_grid3'; }
    public function get_title() { return __('Gallery Grid 3', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-grid'; }
    public function get_categories() { return array('ai-theme-media'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('images', [
            'label' => __('Images', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $images = $s['images'] ?? [];
        ?>
        <section class="ai-gallery ai-gallery-grid3 section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="gallery" data-block-variant="gallery-grid3">
            <div class="max-w-7xl mx-auto px-6">
                <div class="grid md:grid-cols-3 gap-6">
                    <?php foreach ($images as $idx => $image) :
                        $img_url = $image['image']['url'] ?? '';
                        $title = $image['title'] ?? '';
                        $desc = $image['description'] ?? '';
                    ?>
                    <div class="group relative overflow-hidden rounded-xl bg-[var(--bg-secondary)] aspect-[4/3] cursor-pointer">
                        <?php if ($img_url) : ?>
                        <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($title ?: 'Gallery image ' . ($idx + 1)); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                        <?php endif; ?>
                        <div class="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex flex-col justify-end p-6">
                            <?php if ($title) : ?>
                            <h3 class="text-white font-bold text-xl mb-1"><?php echo esc_html($title); ?></h3>
                            <?php endif; ?>
                            <?php if ($desc) : ?>
                            <p class="text-white/80 text-sm"><?php echo esc_html($desc); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
