<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Gallery_Showcase_Editorial extends AI_Widget_Base {
    public function get_name() { return 'ai_gallery_editorial'; }
    public function get_title() { return __('Gallery Editorial', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-justified'; }
    public function get_categories() { return array('ai-theme-media'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('images', [
            'label' => __('Images', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $images = $s['images'] ?? [];
        
        $patterns = [
            'col-span-2 row-span-2',
            'col-span-1 row-span-1',
            'col-span-1 row-span-2',
            'col-span-2 row-span-1',
            'col-span-1 row-span-1',
            'col-span-1 row-span-1',
        ];
        ?>
        <section class="ai-gallery ai-gallery-showcase-editorial relative w-full section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="gallery" data-block-variant="gallery-showcase-editorial">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 md:gap-6" style="grid-auto-rows: 200px;">
                    <?php foreach ($images as $idx => $image) : 
                        $img_url = $image['image']['url'] ?? '';
                        $title = $image['title'] ?? '';
                        $desc = $image['description'] ?? '';
                        $layout = $patterns[$idx % count($patterns)];
                    ?>
                    <div class="group relative overflow-hidden <?php echo esc_attr($layout); ?>">
                        <?php if ($img_url) : ?>
                        <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($title ?: 'Image ' . ($idx + 1)); ?>" class="w-full h-full object-cover grayscale-[30%] group-hover:grayscale-0 transition-all duration-700 group-hover:scale-105">
                        <?php endif; ?>
                        
                        <div class="absolute inset-0 bg-gradient-to-t from-[var(--bg-dark)]/80 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                        
                        <div class="absolute bottom-0 left-0 right-0 p-6 md:p-8 translate-y-full group-hover:translate-y-0 transition-transform duration-500">
                            <span class="text-5xl font-light text-white/30 absolute top-0 right-6" style="font-family: Georgia, serif;">
                                <?php echo str_pad($idx + 1, 2, '0', STR_PAD_LEFT); ?>
                            </span>
                            <?php if ($title) : ?>
                            <h3 class="text-xl md:text-2xl text-white mb-1" style="font-family: Georgia, serif;">
                                <?php echo esc_html($title); ?>
                            </h3>
                            <?php endif; ?>
                            <?php if ($desc) : ?>
                            <p class="text-sm text-white/70"><?php echo esc_html($desc); ?></p>
                            <?php endif; ?>
                        </div>
                        
                        <div class="absolute top-4 left-4 w-8 h-8 border-l border-t border-white/0 group-hover:border-white/50 transition-all duration-500"></div>
                        <div class="absolute bottom-4 right-4 w-8 h-8 border-r border-b border-white/0 group-hover:border-white/50 transition-all duration-500"></div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
