<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Map_Embed extends AI_Widget_Base {
    public function get_name() { return 'ai_map_embed'; }
    public function get_title() { return __('Map Embed', 'ai-theme'); }
    public function get_icon() { return 'eicon-google-maps'; }
    public function get_categories() { return array('ai-theme-map'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('embed_url', ['label' => __('Embed URL', 'ai-theme'), 'type' => Controls_Manager::URL, 'description' => __('Google Maps embed URL', 'ai-theme')]);
        $this->add_control('height', ['label' => __('Height', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '400px']);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-map ai-map-embed w-full section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="map" data-block-variant="map-embed">
            <div class="ai-container">
                <?php if (!empty($s['title'])) : ?>
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <?php endif; ?>
                <?php if (!empty($s['embed_url']['url'])) : ?>
                <div class="bg-[var(--bg-primary)] rounded-2xl overflow-hidden shadow-lg">
                    <div class="ai-map-container w-full" style="height: <?php echo esc_attr($s['height']); ?>">
                        <iframe src="<?php echo esc_url($s['embed_url']['url']); ?>" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" class="w-full"></iframe>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
