<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Map_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_map_minimal'; }
    public function get_title() { return __('Map Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-google-maps'; }
    public function get_categories() { return array('ai-theme-contact'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('embed_url', ['label' => __('Google Maps Embed URL', 'ai-theme'), 'type' => Controls_Manager::URL, 'description' => __('Paste Google Maps embed URL', 'ai-theme')]);
        $this->add_control('height', ['label' => __('Height', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 350, 'min' => 200, 'max' => 800]);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $height = intval($s['height'] ?? 350);
        ?>
        <section class="bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="map" data-block-variant="map-minimal">
            <div class="w-full" style="height: <?php echo $height; ?>px;">
                <?php if (!empty($s['embed_url']['url'])) : ?>
                <iframe 
                    src="<?php echo esc_url($s['embed_url']['url']); ?>" 
                    width="100%" 
                    height="100%" 
                    style="border:0;" 
                    allowfullscreen="" 
                    loading="lazy" 
                    referrerpolicy="no-referrer-when-downgrade"
                    class="w-full h-full grayscale hover:grayscale-0 transition-all duration-300"
                ></iframe>
                <?php else : ?>
                <div class="w-full h-full flex items-center justify-center bg-[var(--bg-secondary)] text-[var(--text-muted)]">
                    <span><?php _e('Add Google Maps embed URL in settings', 'ai-theme'); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
