<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Newsletter_Card extends AI_Widget_Base {
    public function get_name() { return 'ai_newsletter_card'; }
    public function get_title() { return __('Newsletter Card', 'ai-theme'); }
    public function get_icon() { return 'eicon-email-field'; }
    public function get_categories() { return array('ai-theme-forms'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);
        $this->add_control('placeholder', ['label' => __('Email Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('benefit', ['label' => __('Benefit', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('benefits', ['label' => __('Benefits', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => []]);
        
        $this->add_control('footer_note', ['label' => __('Footer Note', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $benefits = $s['benefits'] ?? [];
        ?>
        <section class="py-20 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="newsletter" data-block-variant="newsletter-card">
            <div class="max-w-lg mx-auto px-6">
                <div class="bg-[var(--bg-primary)] rounded-3xl shadow-xl overflow-hidden">
                    <!-- Header -->
                    <div class="p-8 text-center text-white" style="background: linear-gradient(to right, var(--primary), var(--secondary));">
                        <div class="w-16 h-16 bg-white/20 backdrop-blur rounded-2xl flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/></svg>
                        </div>
                        <?php if (!empty($s['heading'])) : ?>
                        <h3 class="text-2xl font-bold text-white mb-2"><?php echo esc_html($s['heading']); ?></h3>
                        <?php endif; ?>
                        <?php if (!empty($s['description'])) : ?>
                        <p class="text-white/80"><?php echo esc_html($s['description']); ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Body -->
                    <div class="p-8">
                        <?php if (!empty($benefits)) : ?>
                        <ul class="space-y-3 mb-8">
                            <?php foreach ($benefits as $item) : ?>
                            <li class="flex items-start gap-3">
                                <div class="w-5 h-5 bg-green-100 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5">
                                    <svg class="w-3 h-3 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                                </div>
                                <span class="text-[var(--text-secondary)]"><?php echo esc_html($item['benefit']); ?></span>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                        <?php endif; ?>

                        <form class="space-y-4">
                            <input type="email" placeholder="<?php echo esc_attr($s['placeholder']); ?>" class="w-full px-5 py-4 border-2 border-[var(--border-color)] rounded-xl text-[var(--text-primary)] placeholder-[var(--text-muted)] focus:outline-none focus:border-[var(--primary)] transition-colors">
                            <button type="submit" class="w-full py-4 text-white font-semibold rounded-xl transition-all shadow-lg hover:opacity-90" style="background: linear-gradient(to right, var(--primary), var(--secondary));">
                                <?php echo esc_html($s['button_text']); ?>
                            </button>
                        </form>

                        <?php if (!empty($s['footer_note'])) : ?>
                        <p class="text-center text-xs text-[var(--text-muted)] mt-4"><?php echo esc_html($s['footer_note']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
