<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Privacy_Accordion extends AI_Widget_Base {
    public function get_name() { return 'ai_privacy_accordion'; }
    public function get_title() { return __('Privacy Accordion', 'ai-theme'); }
    public function get_icon() { return 'eicon-document-file'; }
    public function get_categories() { return array('ai-theme-legal'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('last_updated', array('label' => __('Last Updated', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => 'January 2024'));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Section Title', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('content', array('label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG));

        $this->add_control('sections', array('label' => __('Sections', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array(
            array('title' => 'Information We Collect', 'content' => '<p>We collect information you provide directly to us...</p>'),
            array('title' => 'How We Use Your Information', 'content' => '<p>We use the information we collect to provide and improve our services...</p>'),
            array('title' => 'Information Sharing', 'content' => '<p>We do not share your personal information with third parties except...</p>'),
        )));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $widget_id = $this->get_id();

        // Localized texts
        $t = [
            'last_updated' => ai_get_text('legal.lastUpdated', 'Last updated:'),
        ];
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="privacy" data-block-variant="privacy-accordion">
            <div class="max-w-4xl mx-auto px-6">
                <div class="text-center mb-12">
                    <h1 class="text-3xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($settings['heading']); ?></h1>
                    <?php if (!empty($settings['last_updated'])) : ?>
                        <p class="text-[var(--text-secondary)]"><?php echo esc_html($t['last_updated']); ?> <?php echo esc_html($settings['last_updated']); ?></p>
                    <?php endif; ?>
                </div>
                <div class="space-y-4">
                    <?php foreach ($settings['sections'] as $idx => $section) : ?>
                        <div class="border border-[var(--border-color)] rounded-[var(--card-radius)] overflow-hidden">
                            <button class="accordion-btn w-full px-6 py-4 flex justify-between items-center text-left bg-[var(--bg-secondary)] hover:bg-[var(--bg-tertiary,#e2e8f0)] transition-colors" data-target="accordion-<?php echo esc_attr($widget_id . '-' . $idx); ?>">
                                <span class="font-semibold text-[var(--text-primary)]"><?php echo esc_html($section['title']); ?></span>
                                <svg class="w-5 h-5 text-[var(--text-secondary)] accordion-icon transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                            </button>
                            <div id="accordion-<?php echo esc_attr($widget_id . '-' . $idx); ?>" class="accordion-content hidden px-6 py-4 bg-[var(--bg-primary)]">
                                <div class="prose prose-sm max-w-none text-[var(--text-secondary)]">
                                    <?php echo wp_kses_post($section['content']); ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <script>
        document.querySelectorAll('.accordion-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                const content = document.getElementById(btn.dataset.target);
                const icon = btn.querySelector('.accordion-icon');
                content.classList.toggle('hidden');
                icon.style.transform = content.classList.contains('hidden') ? '' : 'rotate(180deg)';
            });
        });
        </script>
        <?php
    }
}
