<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Privacy_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_privacy_cards'; }
    public function get_title() { return __('Privacy Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-document-file'; }
    public function get_categories() { return array('ai-theme-privacy'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('last_updated', array('label' => __('Last Updated', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('contact_email', array('label' => __('Contact Email', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('content', array('label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG, 'default' => ''));

        $this->add_control('sections', array('label' => __('Sections', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');

        // Localized texts
        $t = [
            'updated' => ai_get_text('legal.updated', 'Updated:'),
            'questions' => ai_get_text('privacy.questions', 'Questions about privacy policy?'),
            'contact_us' => ai_get_text('common.contactUs', 'Contact Us'),
        ];

        $icons = [
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>',
        ];
        $colors = ['from-blue-500 to-blue-600', 'from-green-500 to-green-600', 'from-purple-500 to-purple-600', 'from-orange-500 to-orange-600', 'from-pink-500 to-pink-600', 'from-indigo-500 to-indigo-600'];
        ?>
        <section class="py-16 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="privacy" data-block-variant="privacy-cards">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <div class="text-center mb-12">
                    <h1 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h1>
                    <?php if (!empty($settings['subheading'])) : ?>
                    <p class="text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($settings['last_updated'])) : ?>
                    <p class="text-sm text-[var(--text-muted)] mt-2"><?php echo esc_html($t['updated']); ?> <?php echo esc_html($settings['last_updated']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Cards Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php foreach ($settings['sections'] as $idx => $section) : 
                        $icon = $icons[$idx % count($icons)];
                        $color = $colors[$idx % count($colors)];
                    ?>
                    <div class="bg-[var(--bg-primary)] rounded-2xl p-6 shadow-sm hover:shadow-lg transition-shadow border border-[var(--border-color)]">
                        <div class="w-12 h-12 bg-gradient-to-br <?php echo $color; ?> rounded-xl flex items-center justify-center mb-4 shadow-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><?php echo $icon; ?></svg>
                        </div>
                        <h3 class="font-bold text-lg text-[var(--text-primary)] mb-3"><?php echo esc_html($section['title']); ?></h3>
                        <div class="text-sm text-[var(--text-secondary)] prose prose-sm max-w-none">
                            <?php echo wp_kses_post($section['content']); ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Contact -->
                <?php if (!empty($settings['contact_email'])) : ?>
                <div class="mt-12 text-center">
                    <p class="text-[var(--text-secondary)] mb-3"><?php echo esc_html($t['questions']); ?></p>
                    <a href="mailto:<?php echo esc_attr($settings['contact_email']); ?>" class="inline-flex items-center gap-2 bg-[var(--primary)] text-white px-6 py-3 rounded-xl font-semibold hover:opacity-90 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <?php echo esc_html($t['contact_us']); ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
