<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

/**
 * ProcessCards - Dark glassmorphism design
 * Dark background (slate-950), glassmorphism cards with blur effect, glow effects on hover
 */
class Process_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_process_cards'; }
    public function get_title() { return __('Process Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-grid'; }
    public function get_categories() { return array('ai-theme-process'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('steps', [
            'label' => __('Steps', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => []
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $steps = !empty($s['steps']) ? $s['steps'] : [];
        ?>
        <section class="w-full bg-slate-950 py-20 md:py-28 relative overflow-hidden" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="process" data-block-variant="process-cards">
            <!-- Gradient orbs background -->
            <div class="absolute inset-0 overflow-hidden pointer-events-none">
                <div class="absolute top-1/4 left-1/4 w-96 h-96 bg-[var(--primary)]/20 rounded-full blur-3xl"></div>
                <div class="absolute bottom-1/4 right-1/4 w-96 h-96 bg-[var(--secondary)]/20 rounded-full blur-3xl"></div>
            </div>

            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
                <!-- Header -->
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-16 md:mb-20">
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-[var(--primary)] text-sm tracking-widest uppercase mb-4"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Cards Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <?php foreach ($steps as $i => $step) : ?>
                    <div class="group relative">
                        <!-- Glow effect on hover -->
                        <div class="absolute -inset-0.5 bg-gradient-to-r from-[var(--primary)] to-[var(--secondary)] rounded-2xl opacity-0 group-hover:opacity-50 blur transition-all duration-500"></div>

                        <!-- Card -->
                        <div class="relative bg-white/5 backdrop-blur-xl rounded-2xl p-6 border border-white/10 h-full transition-all duration-300 group-hover:bg-white/10 group-hover:border-white/20">
                            <!-- Number badge -->
                            <div class="w-12 h-12 bg-slate-800 rounded-xl flex items-center justify-center mb-6 group-hover:bg-gradient-to-r group-hover:from-[var(--primary)] group-hover:to-[var(--secondary)] transition-all duration-300">
                                <span class="text-xl font-bold text-slate-400 group-hover:text-white transition-colors">
                                    <?php echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                                </span>
                            </div>

                            <!-- Content -->
                            <h3 class="text-xl font-semibold text-white mb-3"><?php echo esc_html($step['title']); ?></h3>
                            <?php if (!empty($step['description'])) : ?>
                            <p class="text-slate-400 text-sm leading-relaxed"><?php echo esc_html($step['description']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
