<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

/**
 * ProcessHorizontal - Горизонтальный процесс
 * Сетка из 4 колонок с номерами в синем круге
 */
class Process_Horizontal extends AI_Widget_Base {
    public function get_name() { return 'ai_process_horizontal'; }
    public function get_title() { return __('Process Horizontal', 'ai-theme'); }
    public function get_icon() { return 'eicon-navigation-horizontal'; }
    public function get_categories() { return array('ai-theme-process'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        
        $this->add_control('steps', [
            'label' => __('Steps', 'ai-theme'), 
            'type' => Controls_Manager::REPEATER, 
            'fields' => $repeater->get_controls(),
            'default' => []
        ]);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $steps = !empty($s['steps']) ? $s['steps'] : [];
        ?>
        <section class="w-full section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="process" data-block-variant="process-horizontal">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-16">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Desktop: горизонтальная сетка -->
                <div class="hidden lg:flex items-start justify-between">
                    <?php foreach ($steps as $i => $step) :
                        $width = 100 / count($steps);
                    ?>
                    <div class="flex items-start" style="width: <?php echo $width; ?>%">
                        <div class="flex flex-col items-center w-full">
                            <!-- Номер в круге -->
                            <div class="w-20 h-20 bg-[var(--primary)] rounded-full flex items-center justify-center text-white mb-4 relative z-10 shadow-lg">
                                <span class="text-2xl font-bold"><?php echo $i + 1; ?></span>
                            </div>
                            <!-- Текст -->
                            <div class="text-center px-2">
                                <h3 class="text-lg font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($step['title']); ?></h3>
                                <?php if (!empty($step['description'])) : ?>
                                <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($step['description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if ($i < count($steps) - 1) : ?>
                        <!-- Соединительная линия -->
                        <div class="flex items-center justify-center" style="width: 100%; margin-top: 40px;">
                            <div class="h-1 bg-[var(--primary)] flex-1"></div>
                            <svg class="w-6 h-6 text-[var(--primary)] mx-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Mobile/Tablet: вертикальный список -->
                <div class="lg:hidden space-y-6">
                    <?php foreach ($steps as $i => $step) : ?>
                    <div>
                        <div class="flex items-start gap-4">
                            <div class="w-16 h-16 bg-[var(--primary)] rounded-full flex items-center justify-center text-white flex-shrink-0 shadow-lg">
                                <span class="text-xl font-bold"><?php echo $i + 1; ?></span>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($step['title']); ?></h3>
                                <?php if (!empty($step['description'])) : ?>
                                <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($step['description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if ($i < count($steps) - 1) : ?>
                        <div class="flex items-center gap-2 ml-8 my-4">
                            <div class="w-1 h-8 bg-[var(--primary)]"></div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
