<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

/**
 * ProcessTimeline - Elegant vertical timeline
 * Gradient background, central timeline line, alternating cards left-right
 */
class Process_Timeline extends AI_Widget_Base {
    public function get_name() { return 'ai_process_timeline'; }
    public function get_title() { return __('Process Timeline', 'ai-theme'); }
    public function get_icon() { return 'eicon-time-line'; }
    public function get_categories() { return array('ai-theme-process'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('steps', [
            'label' => __('Steps', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => []
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $steps = !empty($s['steps']) ? $s['steps'] : [];
        ?>
        <section class="w-full py-20 md:py-32 overflow-hidden" style="background: linear-gradient(to bottom, var(--bg-secondary), var(--bg-primary));" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="process" data-block-variant="process-timeline">
            <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-20">
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-sm tracking-widest uppercase text-[var(--primary)] mb-4"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-4xl md:text-5xl lg:text-6xl font-bold text-[var(--text-primary)]"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Timeline -->
                <div class="relative">
                    <!-- Central timeline line (desktop) -->
                    <div class="absolute left-1/2 top-0 bottom-0 w-px -translate-x-1/2 hidden md:block">
                        <div class="absolute inset-0 bg-[var(--border-color,#e5e7eb)]"></div>
                        <!-- Progress line -->
                        <div class="absolute top-0 left-0 right-0" style="height: 50%; background: linear-gradient(to bottom, var(--primary), var(--secondary));"></div>
                    </div>

                    <!-- Steps -->
                    <div class="relative space-y-16 md:space-y-0">
                        <?php foreach ($steps as $i => $step) :
                            $isEven = $i % 2 === 0;
                        ?>
                        <div class="relative md:min-h-[200px]">
                            <!-- Mobile layout -->
                            <div class="md:hidden flex items-start gap-4">
                                <!-- Timeline dot -->
                                <div class="relative z-10 flex-shrink-0">
                                    <div class="w-12 h-12 rounded-full flex items-center justify-center shadow-lg text-white" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                                        <span class="text-sm font-bold"><?php echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?></span>
                                    </div>
                                    <?php if ($i < count($steps) - 1) : ?>
                                    <div class="absolute top-12 left-1/2 w-px h-16 -translate-x-1/2" style="background: linear-gradient(to bottom, var(--primary), var(--secondary));"></div>
                                    <?php endif; ?>
                                </div>
                                <!-- Content -->
                                <div class="pt-1 pb-8">
                                    <span class="inline-block px-2 py-0.5 rounded-full text-xs font-medium mb-2 bg-[var(--primary-light,#dbeafe)] text-[var(--primary)]">
                                        <?php echo ai_get_text('common.step', 'Step'); ?> <?php echo $i + 1; ?>
                                    </span>
                                    <h3 class="text-xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($step['title']); ?></h3>
                                    <?php if (!empty($step['description'])) : ?>
                                    <p class="text-[var(--text-secondary)]"><?php echo esc_html($step['description']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Desktop layout - alternating -->
                            <div class="hidden md:grid md:grid-cols-2 md:gap-16 items-center">
                                <!-- Left content -->
                                <div class="<?php echo $isEven ? 'text-right pr-16' : 'order-2 pl-16'; ?>">
                                    <?php if ($isEven) : ?>
                                    <span class="inline-block px-3 py-1 rounded-full text-xs font-medium mb-3 bg-[var(--primary-light,#dbeafe)] text-[var(--primary)]">
                                        <?php echo ai_get_text('common.step', 'Step'); ?> <?php echo $i + 1; ?>
                                    </span>
                                    <h3 class="text-2xl lg:text-3xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($step['title']); ?></h3>
                                    <?php if (!empty($step['description'])) : ?>
                                    <p class="text-[var(--text-secondary)] text-lg"><?php echo esc_html($step['description']); ?></p>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </div>

                                <!-- Center dot -->
                                <div class="absolute left-1/2 -translate-x-1/2 z-10">
                                    <div class="w-14 h-14 rounded-full flex items-center justify-center shadow-xl text-white" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                                        <span class="text-lg font-bold"><?php echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?></span>
                                    </div>
                                </div>

                                <!-- Right content -->
                                <div class="<?php echo !$isEven ? 'text-left pl-16' : 'order-2 pr-16'; ?>">
                                    <?php if (!$isEven) : ?>
                                    <span class="inline-block px-3 py-1 rounded-full text-xs font-medium mb-3 bg-[var(--primary-light,#dbeafe)] text-[var(--primary)]">
                                        <?php echo ai_get_text('common.step', 'Step'); ?> <?php echo $i + 1; ?>
                                    </span>
                                    <h3 class="text-2xl lg:text-3xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($step['title']); ?></h3>
                                    <?php if (!empty($step['description'])) : ?>
                                    <p class="text-[var(--text-secondary)] text-lg"><?php echo esc_html($step['description']); ?></p>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
