<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

/**
 * ProcessVertical - Вертикальный процесс с таймлайном
 * Timeline дизайн с линией слева и номерами в круге
 */
class Process_Vertical extends AI_Widget_Base {
    public function get_name() { return 'ai_process_vertical'; }
    public function get_title() { return __('Process Vertical', 'ai-theme'); }
    public function get_icon() { return 'eicon-navigator'; }
    public function get_categories() { return array('ai-theme-process'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        
        $this->add_control('steps', [
            'label' => __('Steps', 'ai-theme'), 
            'type' => Controls_Manager::REPEATER, 
            'fields' => $repeater->get_controls(),
            'default' => []
        ]);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $steps = !empty($s['steps']) ? $s['steps'] : [];
        ?>
        <section class="w-full section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="process" data-block-variant="process-vertical">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-16">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <div class="relative">
                    <!-- Timeline линия -->
                    <div class="absolute left-8 md:left-10 top-0 bottom-0 w-0.5 bg-[var(--primary-light,#93c5fd)]" aria-hidden="true"></div>

                    <div class="space-y-8 md:space-y-12">
                        <?php foreach ($steps as $i => $step) : ?>
                        <div class="relative flex items-start gap-6 md:gap-8">
                            <!-- Номер в круге -->
                            <div class="flex-shrink-0 relative z-10">
                                <div class="w-16 h-16 md:w-20 md:h-20 bg-[var(--primary)] rounded-full flex items-center justify-center text-white shadow-lg transition-all duration-300 hover:scale-110">
                                    <span class="text-xl md:text-2xl font-bold"><?php echo $i + 1; ?></span>
                                </div>
                            </div>
                            <!-- Контент -->
                            <div class="flex-1 pb-8">
                                <h3 class="text-xl md:text-2xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($step['title']); ?></h3>
                                <?php if (!empty($step['description'])) : ?>
                                <p class="text-base md:text-lg text-[var(--text-secondary)]"><?php echo esc_html($step['description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
