<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Services_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_services_minimal'; }
    public function get_title() { return __('Services Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-service-icon'; }
    public function get_categories() { return array('ai-theme-general'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $repeater->add_control('link', array('label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL));

        $this->add_control('services', array('label' => __('Services', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-12 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="services" data-block-variant="services-minimal">
            <div class="max-w-3xl mx-auto px-6">
                <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-2xl font-bold text-[var(--text-primary)] mb-8"><?php echo esc_html($settings['heading']); ?></h2>
                <?php endif; ?>
                <div class="space-y-6">
                    <?php foreach ($settings['services'] as $idx => $service) : ?>
                        <div class="flex gap-4">
                            <div class="text-2xl font-bold text-[var(--primary)] opacity-50"><?php echo str_pad($idx + 1, 2, '0', STR_PAD_LEFT); ?></div>
                            <div class="flex-1">
                                <h3 class="font-bold text-[var(--text-primary)] mb-1"><?php echo esc_html($service['title']); ?></h3>
                                <?php if (!empty($service['description'])) : ?>
                                    <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($service['description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
