<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Shipping_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_shipping_minimal'; }
    public function get_title() { return __('Shipping Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-delivery'; }
    public function get_categories() { return array('ai-theme-shipping'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('free_shipping_from', array('label' => __('Free Shipping From', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 5000));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('price', array('label' => __('Price', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('time', array('label' => __('Time', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $this->add_control('options', array('label' => __('Options', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $free_from = intval($settings['free_shipping_from']);
        ?>
        <section class="py-12 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="shipping" data-block-variant="shipping-minimal">
            <div class="max-w-2xl mx-auto px-4">
                <div class="flex items-center justify-between mb-6">
                    <?php if (!empty($settings['heading'])) : ?>
                    <h3 class="text-xl font-bold text-[var(--text-primary)]"><?php echo esc_html($settings['heading']); ?></h3>
                    <?php endif; ?>
                    
                    <?php if ($free_from > 0) : ?>
                    <span class="text-sm text-emerald-600 font-medium bg-emerald-50 px-3 py-1 rounded-full">
                        <?php printf(__('Free from %s', 'ai-theme'), number_format($free_from, 0, ',', ' ')); ?>
                    </span>
                    <?php endif; ?>
                </div>
                
                <div class="bg-[var(--bg-secondary)] rounded-xl p-1">
                    <?php foreach ($settings['options'] as $idx => $opt) : 
                        $is_free = (stripos($opt['price'], 'free') !== false || $opt['price'] === '0' || $opt['price'] === '0 ₽');
                    ?>
                    <div class="flex justify-between items-center p-4 <?php echo $idx > 0 ? 'border-t border-[var(--border-color)]' : ''; ?> hover:bg-[var(--bg-primary)] rounded-lg transition-colors">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-[var(--primary-light,#dbeafe)] rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>
                                </svg>
                            </div>
                            <div>
                                <span class="font-semibold text-[var(--text-primary)]"><?php echo esc_html($opt['title']); ?></span>
                                <span class="text-sm text-[var(--text-muted)] ml-2"><?php echo esc_html($opt['time']); ?></span>
                            </div>
                        </div>
                        <span class="font-bold <?php echo $is_free ? 'text-emerald-600' : 'text-[var(--text-primary)]'; ?>">
                            <?php echo esc_html($opt['price']); ?>
                        </span>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
