<?php
/**
 * Stats Counter Widget
 *
 * Brutalist design with bold borders and large numbers
 *
 * @package AI_Theme
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit;
}

class Stats_Counter extends AI_Widget_Base {

    public function get_name() {
        return 'ai_stats_counter';
    }

    public function get_title() {
        return __('Stats Counter', 'ai-theme');
    }

    public function get_icon() {
        return 'eicon-number-field';
    }

    public function get_categories() {
        return array('ai-theme-stats');
    }

    public function get_keywords() {
        return array('stats', 'statistics', 'numbers', 'counter', 'brutalist', 'bold', 'ai');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'ai-theme'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'heading',
            array(
                'label'   => __('Heading', 'ai-theme'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            )
        );

        $this->add_control(
            'subheading',
            array(
                'label'   => __('Subheading', 'ai-theme'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => '',
            )
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'value',
            array(
                'label'   => __('Value', 'ai-theme'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            )
        );

        $repeater->add_control(
            'label',
            array(
                'label'   => __('Label', 'ai-theme'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            )
        );

        $this->add_control(
            'stats',
            array(
                'label'   => __('Stats', 'ai-theme'),
                'type'    => Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => array(),
            )
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $stats = $settings['stats'];
        $stats_count = count($stats);
        ?>
        <section
            class="ai-stats ai-stats-counter py-20 md:py-28 section-secondary"
            data-theme="<?php echo esc_attr($theme); ?>" data-block-type="stats"
            data-block-variant="stats-counter"
        >
            <div class="max-w-7xl mx-auto px-6">
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                    <div class="mb-16">
                        <?php if (!empty($settings['heading'])) : ?>
                            <h2 class="text-5xl md:text-7xl font-black text-[var(--text-primary)] mb-4 uppercase tracking-tight">
                                <?php echo esc_html($settings['heading']); ?>
                            </h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['subheading'])) : ?>
                            <p class="text-xl text-[var(--text-secondary)] max-w-xl font-light">
                                <?php echo esc_html($settings['subheading']); ?>
                            </p>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <!-- Stats Grid - Brutalist Layout -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-0 border-4 border-[var(--text-primary)]">
                    <?php foreach ($stats as $idx => $stat) :
                        $border_right = ($idx % 2 === 0 && $idx < $stats_count - 1) ? 'md:border-r-4' : '';
                        $border_bottom = ($idx < $stats_count - 2) ? 'border-b-4 md:border-b-4' : (($idx < $stats_count - 1) ? 'border-b-4 md:border-b-0' : '');
                    ?>
                        <div class="p-10 md:p-12 <?php echo esc_attr($border_right); ?> <?php echo esc_attr($border_bottom); ?> border-[var(--text-primary)] bg-[var(--bg-primary)] hover:bg-[var(--bg-dark,#111827)] hover:text-white group transition-colors duration-300">
                            <!-- Large Number -->
                            <div class="text-6xl md:text-8xl lg:text-9xl font-black tracking-tighter mb-4 text-[var(--text-primary)] group-hover:text-white transition-colors" style="line-height: 0.9;">
                                <?php echo esc_html($stat['value']); ?>
                            </div>

                            <!-- Label with Line -->
                            <div class="flex items-center gap-4">
                                <div class="h-0.5 w-8 bg-[var(--text-primary)] group-hover:bg-white transition-colors"></div>
                                <span class="text-sm uppercase tracking-[0.2em] font-bold text-[var(--text-secondary)] group-hover:text-white/70 transition-colors">
                                    <?php echo esc_html($stat['label']); ?>
                                </span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Bottom Marker -->
                <div class="mt-8 flex items-center gap-2">
                    <div class="w-4 h-4 bg-[var(--primary)]"></div>
                </div>
            </div>
        </section>
        <?php
    }
}
