<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Stats_V1 extends AI_Widget_Base {
    public function get_name() { return 'ai_stats_v1'; }
    public function get_title() { return __('Stats V1', 'ai-theme'); }
    public function get_icon() { return 'eicon-number-field'; }
    public function get_categories() { return array('ai-theme-stats'); }

    public function get_keywords() {
        return array('stats', 'statistics', 'numbers', 'gradient', 'emoji', 'ai');
    }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $repeater = new Repeater();
        $repeater->add_control('value', ['label' => __('Value', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('label', ['label' => __('Label', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('suffix', ['label' => __('Suffix', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('stats', ['label' => __('Stats', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $stats_count = count($s['stats']);
        $grid_cols = $stats_count <= 4 ? 'md:grid-cols-4' : 'md:grid-cols-3';
        ?>
        <section class="ai-stats ai-stats-v1 py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="stats" data-block-variant="stats-v1">
            <div class="ai-container">
                <?php if (!empty($s['title'])) : ?>
                <h2 class="ai-stats-title text-4xl font-bold text-[var(--text-primary)] text-center mb-4"><?php echo esc_html($s['title']); ?></h2>
                <?php endif; ?>
                <?php if (!empty($s['subheading'])) : ?>
                <p class="text-[var(--text-secondary)] text-center mb-12 max-w-2xl mx-auto"><?php echo esc_html($s['subheading']); ?></p>
                <?php endif; ?>
                <div class="ai-stats-items grid grid-cols-2 gap-8 <?php echo $grid_cols; ?>">
                    <?php foreach ($s['stats'] as $index => $st) : ?>
                    <div class="ai-stat-item text-center">
                        <div class="inline-flex items-center justify-center w-16 h-16 bg-[var(--bg-secondary)] rounded-2xl mb-4">
                            <span class="text-3xl"><?php echo $this->get_stat_emoji($st['label'], $index); ?></span>
                        </div>
                        <div class="ai-stat-value text-4xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($this->sanitize_stat_value($st['value'])); ?><?php echo esc_html($st['suffix']); ?></div>
                        <div class="ai-stat-label text-[var(--text-secondary)]"><?php echo esc_html($st['label']); ?></div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }

    /**
     * Sanitize stat value - remove any placeholder artifacts like {{IMAGE_ID}} or {hash}
     */
    private function sanitize_stat_value($value) {
        if (empty($value)) return '';

        // Remove any {{...}} placeholders that weren't replaced
        $value = preg_replace('/\{\{[^}]+\}\}/', '', $value);

        // Remove {hash} artifacts anywhere in string (hex strings 8+ chars in braces)
        $value = preg_replace('/\{[a-f0-9\-]{8,}\}/', '', $value);

        // Remove orphaned { followed by hex (unclosed placeholder)
        $value = preg_replace('/\{[a-f0-9\-]{8,}[^}]*$/', '', $value);

        return trim($value);
    }

    private function get_stat_emoji($label, $index) {
        $label_lower = strtolower($label);

        if (strpos($label_lower, 'user') !== false || strpos($label_lower, 'client') !== false) return '👥';
        if (strpos($label_lower, 'countr') !== false || strpos($label_lower, 'city') !== false) return '🌍';
        if (strpos($label_lower, 'satisf') !== false || strpos($label_lower, 'rating') !== false) return '🏆';
        if (strpos($label_lower, 'project') !== false || strpos($label_lower, 'order') !== false) return '📈';
        if (strpos($label_lower, 'year') !== false || strpos($label_lower, 'experience') !== false) return '📅';
        if (strpos($label_lower, 'employee') !== false || strpos($label_lower, 'team') !== false) return '👨‍💻';
        if (strpos($label_lower, 'award') !== false) return '🏅';
        if (strpos($label_lower, 'partner') !== false) return '🤝';

        $default_emojis = ['📊', '⭐', '🚀', '💼', '🎯', '✨'];
        return $default_emojis[$index % count($default_emojis)];
    }
}
