<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Team_Showcase_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_team_showcase_minimal'; }
    public function get_title() { return __('Team Showcase Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-person'; }
    public function get_categories() { return array('ai-theme-team'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('name', array('label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('role', array('label' => __('Role', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('image', array('label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA));

        $this->add_control('members', array('label' => __('Members', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-12 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="team" data-block-variant="team-showcase-minimal">
            <div class="max-w-4xl mx-auto px-6">
                <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-2xl font-bold text-[var(--text-primary)] mb-8"><?php echo esc_html($settings['heading']); ?></h2>
                <?php endif; ?>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                    <?php foreach ($settings['members'] as $member) : ?>
                        <div class="text-center">
                            <div class="w-20 h-20 rounded-full overflow-hidden mx-auto mb-3 bg-[var(--bg-primary)]">
                                <?php if (!empty($member['image']['url'])) : ?>
                                    <img src="<?php echo esc_url($member['image']['url']); ?>" alt="<?php echo esc_attr($member['name']); ?>" class="w-full h-full object-cover" />
                                <?php endif; ?>
                            </div>
                            <h3 class="font-medium text-[var(--text-primary)] text-sm"><?php echo esc_html($member['name']); ?></h3>
                            <p class="text-xs text-[var(--text-muted)]"><?php echo esc_html($member['role']); ?></p>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
