<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Testimonials_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_testimonials_minimal'; }
    public function get_title() { return __('Testimonials Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-testimonial'; }
    public function get_categories() { return array('ai-theme-testimonials'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('name', ['label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('position', ['label' => __('Position', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('testimonials', ['label' => __('Testimonials', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('blocks.testimonials.heading', '');
        $testimonials = !empty($s['testimonials']) ? $s['testimonials'] : [];
        
        if (empty($testimonials)) return;
        ?>
        <section class="ai-testimonials ai-testimonials-minimal section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="testimonials" data-block-variant="testimonials-minimal">
            <div class="ai-container-narrow">
                <?php if (!empty($title)) : ?>
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($title); ?></h2>
                </div>
                <?php endif; ?>
                <div class="space-y-8">
                    <?php foreach ($testimonials as $t) : ?>
                    <div class="border-l-4 pl-6 py-2 border-[var(--primary)]">
                        <div class="text-[var(--text-secondary)] text-lg mb-4 italic prose prose-sm max-w-none">"<?php echo wp_kses_post($t['content'] ?? ''); ?>"</div>
                        <div class="flex items-center gap-3">
                            <div>
                                <p class="font-bold text-[var(--text-primary)]"><?php echo esc_html($t['name'] ?? ''); ?></p>
                                <?php if (!empty($t['position'])) : ?>
                                <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($t['position']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
