<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Testimonials_Slider extends AI_Widget_Base {
    public function get_name() { return 'ai_testimonials_slider'; }
    public function get_title() { return __('Testimonials Slider', 'ai-theme'); }
    public function get_icon() { return 'eicon-slider-push'; }
    public function get_categories() { return array('ai-theme-testimonials'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('name', ['label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('position', ['label' => __('Position', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('avatar', ['label' => __('Avatar', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $this->add_control('testimonials', ['label' => __('Testimonials', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('blocks.testimonials.heading', '');
        $testimonials = !empty($s['testimonials']) ? $s['testimonials'] : [];
        
        if (empty($testimonials)) return;
        
        $first_testimonial = $testimonials[0];
        ?>
        <section class="ai-testimonials ai-testimonials-slider py-16 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="testimonials" data-block-variant="testimonials-slider">
            <div class="max-w-4xl mx-auto px-6">
                <div class="text-center mb-10">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($title); ?></h2>
                </div>
                <div class="relative">
                    <?php if ($first_testimonial) : ?>
                    <div class="bg-[var(--bg-primary)] p-8 md:p-10 rounded-2xl shadow-sm border border-[var(--border-color,#e5e7eb)] text-center">
                        <svg class="w-10 h-10 text-[var(--text-muted)] opacity-30 mx-auto mb-4" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"/>
                        </svg>
                        <p class="text-lg md:text-xl text-[var(--text-secondary)] mb-6 leading-relaxed max-w-2xl mx-auto">"<?php echo wp_kses_post($first_testimonial['content'] ?? ''); ?>"</p>
                        <div class="flex flex-col items-center">
                            <?php if (!empty($first_testimonial['avatar']['url'])) : ?>
                            <img src="<?php echo esc_url($first_testimonial['avatar']['url']); ?>" alt="<?php echo esc_attr($first_testimonial['name'] ?? ''); ?>" class="w-16 h-16 rounded-full border-2 border-[var(--border-color,#e5e7eb)] mb-3 object-cover">
                            <?php else : ?>
                            <div class="w-16 h-16 rounded-full border-2 border-[var(--border-color,#e5e7eb)] mb-3 flex items-center justify-center bg-[var(--bg-secondary)] text-[var(--text-secondary)] font-bold text-xl">
                                <?php echo esc_html(mb_substr($first_testimonial['name'] ?? 'U', 0, 1)); ?>
                            </div>
                            <?php endif; ?>
                            <p class="font-bold text-lg text-[var(--text-primary)]"><?php echo esc_html($first_testimonial['name'] ?? ''); ?></p>
                            <?php if (!empty($first_testimonial['position'])) : ?>
                            <p class="text-[var(--text-muted)] text-sm"><?php echo esc_html($first_testimonial['position']); ?></p>
                            <?php endif; ?>
                            <div class="flex gap-0.5 mt-2">
                                <?php for ($i = 0; $i < 5; $i++) : ?>
                                <span class="text-base">⭐</span>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <?php if (count($testimonials) > 1) : ?>
                <div class="flex justify-center gap-2 mt-6">
                    <?php foreach ($testimonials as $index => $t) : ?>
                    <button class="<?php echo $index === 0 ? 'w-6 bg-[var(--primary)]' : 'w-2.5 bg-[var(--bg-tertiary,#d1d5db)]'; ?> h-2.5 rounded-full"></button>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
