<?php
/**
 * Text Wide Widget
 * Широкий двухколоночный текст для описания компании (300-500 слов)
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Text_Wide extends AI_Widget_Base {
    public function get_name() { return 'ai_text_wide'; }
    public function get_title() { return __('Text Wide', 'ai-theme'); }
    public function get_icon() { return 'eicon-text-align-left'; }
    public function get_categories() { return array('ai-theme-text'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);
        $this->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG, 'default' => '']);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-16 md:py-20 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="text" data-block-variant="text-wide">
            <div class="max-w-6xl mx-auto px-4 sm:px-6">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="mb-10 text-center">
                    <?php if (!empty($s['heading'])) : ?>
                        <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                        <p class="text-lg text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <?php if (!empty($s['content'])) : ?>
                <div class="grid md:grid-cols-2 gap-8 md:gap-12">
                    <div class="space-y-4 text-[var(--text-secondary)] leading-relaxed">
                        <?php echo wp_kses_post($s['content']); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
