<?php
/**
 * Empty cart page template
 *
 * Custom styled empty cart for AI Theme.
 * This template is displayed when the cart is empty.
 *
 * @package AI_Theme
 */

defined('ABSPATH') || exit;

/*
 * @hooked wc_empty_cart_message - 10
 */
// do_action('woocommerce_cart_is_empty'); // We replace this with custom markup
?>

<div class="ai-cart-page ai-cart-empty py-8 md:py-12" data-theme="<?php echo esc_attr(get_option('ai_theme_style', 'modern')); ?>">
    <div class="ai-container">

        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2"><?php echo esc_html(ai_get_text('ecommerce.cart.title', 'Cart')); ?></h1>
            <nav class="flex text-sm text-gray-500">
                <a href="<?php echo esc_url(home_url('/')); ?>" class="hover:text-primary transition-colors"><?php echo esc_html(ai_get_text('common.home', 'Home')); ?></a>
                <span class="mx-2">/</span>
                <span class="text-gray-900"><?php echo esc_html(ai_get_text('ecommerce.cart.title', 'Cart')); ?></span>
            </nav>
        </div>

        <!-- Empty Cart Message -->
        <div class="text-center py-16 bg-gray-50 rounded-2xl">
            <div class="w-24 h-24 mx-auto mb-6 bg-gray-200 rounded-full flex items-center justify-center">
                <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
            </div>
            <h2 class="text-2xl font-semibold text-gray-900 mb-2"><?php echo esc_html(ai_get_text('ecommerce.cart.emptyTitle', 'Your cart is empty')); ?></h2>
            <p class="text-gray-600 mb-8 max-w-md mx-auto"><?php echo esc_html(ai_get_text('ecommerce.cart.emptyDescription', 'Looks like you haven\'t added any items to your cart yet. Browse our catalog to find something you like.')); ?></p>

            <?php if (wc_get_page_id('shop') > 0) : ?>
                <a href="<?php echo esc_url(apply_filters('woocommerce_return_to_shop_redirect', wc_get_page_permalink('shop'))); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white font-semibold rounded-lg hover:opacity-90 transition-opacity wc-backward">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    <?php echo esc_html(ai_get_text('ecommerce.cart.continueShopping', 'Continue Shopping')); ?>
                </a>
            <?php endif; ?>
        </div>

    </div>
</div>
