<?php
/**
 * Checkout Form Template
 *
 * Custom styled checkout page for AI Theme
 *
 * @package AI_Theme
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_checkout_form', $checkout);

// If checkout registration is disabled and not logged in, the user cannot checkout.
if (!$checkout->is_registration_enabled() && $checkout->is_registration_required() && !is_user_logged_in()) {
    echo '<div class="ai-checkout-login-notice max-w-2xl mx-auto my-12 p-8 bg-amber-50 border border-amber-200 rounded-2xl text-center">';
    echo '<svg class="w-12 h-12 mx-auto mb-4 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>';
    echo '<h2 class="text-xl font-bold text-gray-900 mb-2">' . esc_html(ai_theme_get_localized_text('ecommerce.checkout.loginRequired', 'Login required')) . '</h2>';
    echo '<p class="text-gray-600 mb-4">' . esc_html(ai_theme_get_localized_text('ecommerce.checkout.loginRequiredMessage', 'You must be logged in to checkout.')) . '</p>';
    echo '<a href="' . esc_url(wc_get_page_permalink('myaccount')) . '" class="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white font-semibold rounded-lg hover:opacity-90 transition-opacity">' . esc_html(ai_theme_get_localized_text('profile.logIn', 'Log in')) . '</a>';
    echo '</div>';
    return;
}
?>

<div class="ai-checkout-page py-8 md:py-12" data-theme="<?php echo esc_attr(get_option('ai_theme_style', 'modern')); ?>">
    <div class="ai-container">

        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2"><?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.title', 'Checkout')); ?></h1>
            <nav class="flex text-sm text-gray-500">
                <a href="<?php echo esc_url(home_url('/')); ?>" class="hover:text-primary transition-colors"><?php echo esc_html(ai_theme_get_localized_text('common.home', 'Home')); ?></a>
                <span class="mx-2">/</span>
                <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="hover:text-primary transition-colors"><?php echo esc_html(ai_theme_get_localized_text('ecommerce.cart.title', 'Cart')); ?></a>
                <span class="mx-2">/</span>
                <span class="text-gray-900"><?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.title', 'Checkout')); ?></span>
            </nav>
        </div>

        <!-- Checkout Steps Indicator -->
        <div class="mb-8 hidden md:block">
            <div class="flex items-center justify-center">
                <div class="flex items-center">
                    <div class="flex items-center justify-center w-10 h-10 bg-gray-200 text-gray-500 rounded-full">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </div>
                    <span class="ml-2 text-sm font-medium text-gray-500"><?php echo esc_html(ai_theme_get_localized_text('ecommerce.cart.title', 'Cart')); ?></span>
                </div>
                <div class="w-16 h-0.5 bg-gray-200 mx-4"></div>
                <div class="flex items-center">
                    <div class="flex items-center justify-center w-10 h-10 bg-primary text-white rounded-full">
                        <span class="font-semibold">2</span>
                    </div>
                    <span class="ml-2 text-sm font-medium text-gray-900"><?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.title', 'Checkout')); ?></span>
                </div>
                <div class="w-16 h-0.5 bg-gray-200 mx-4"></div>
                <div class="flex items-center">
                    <div class="flex items-center justify-center w-10 h-10 bg-gray-200 text-gray-500 rounded-full">
                        <span class="font-semibold">3</span>
                    </div>
                    <span class="ml-2 text-sm font-medium text-gray-500"><?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.complete', 'Complete')); ?></span>
                </div>
            </div>
        </div>

        <form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data">

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Main Checkout Form -->
                <div class="lg:col-span-2 space-y-6">

                    <?php if ($checkout->get_checkout_fields()) : ?>

                        <?php do_action('woocommerce_checkout_before_customer_details'); ?>

                        <!-- Billing Details -->
                        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden" id="customer_details">
                            <div class="px-6 py-4 bg-gray-50 border-b border-gray-100">
                                <h3 class="text-lg font-semibold text-gray-900 flex items-center gap-2">
                                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                    <?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.billingDetails', 'Billing details')); ?>
                                </h3>
                            </div>
                            <div class="p-6">
                                <?php do_action('woocommerce_checkout_billing'); ?>
                            </div>
                        </div>

                        <!-- Shipping Details -->
                        <?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>
                        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                            <div class="px-6 py-4 bg-gray-50 border-b border-gray-100">
                                <h3 class="text-lg font-semibold text-gray-900 flex items-center gap-2">
                                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                    </svg>
                                    <?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.shipping', 'Shipping')); ?>
                                </h3>
                            </div>
                            <div class="p-6">
                                <?php do_action('woocommerce_checkout_shipping'); ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php do_action('woocommerce_checkout_after_customer_details'); ?>

                    <?php endif; ?>

                    <!-- Additional Information -->
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-6 py-4 bg-gray-50 border-b border-gray-100">
                            <h3 class="text-lg font-semibold text-gray-900 flex items-center gap-2">
                                <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"></path>
                                </svg>
                                <?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.additionalInfo', 'Additional information')); ?>
                            </h3>
                        </div>
                        <div class="p-6">
                            <?php do_action('woocommerce_before_order_notes', $checkout); ?>

                            <?php if (apply_filters('woocommerce_enable_order_notes_field', 'yes' === get_option('woocommerce_enable_order_comments', 'yes'))) : ?>
                                <?php foreach ($checkout->get_checkout_fields('order') as $key => $field) : ?>
                                    <?php woocommerce_form_field($key, $field, $checkout->get_value($key)); ?>
                                <?php endforeach; ?>
                            <?php endif; ?>

                            <?php do_action('woocommerce_after_order_notes', $checkout); ?>
                        </div>
                    </div>

                </div>

                <!-- Order Summary Sidebar -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden sticky top-24">
                        <div class="px-6 py-4 bg-gray-50 border-b border-gray-100">
                            <h3 class="text-lg font-semibold text-gray-900"><?php echo esc_html(ai_theme_get_localized_text('ecommerce.checkout.yourOrder', 'Your order')); ?></h3>
                        </div>

                        <div class="p-6">
                            <?php do_action('woocommerce_checkout_before_order_review_heading'); ?>

                            <?php do_action('woocommerce_checkout_before_order_review'); ?>

                            <div id="order_review" class="woocommerce-checkout-review-order">
                                <?php do_action('woocommerce_checkout_order_review'); ?>
                            </div>

                            <?php do_action('woocommerce_checkout_after_order_review'); ?>
                        </div>
                    </div>
                </div>
            </div>

        </form>

    </div>
</div>

<?php do_action('woocommerce_after_checkout_form', $checkout); ?>

<style>
/* Form fields styling */
.ai-checkout-page .woocommerce-input-wrapper {
    width: 100%;
}
.ai-checkout-page input[type="text"],
.ai-checkout-page input[type="email"],
.ai-checkout-page input[type="tel"],
.ai-checkout-page input[type="password"],
.ai-checkout-page input[type="number"],
.ai-checkout-page select,
.ai-checkout-page textarea {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 1px solid #e5e7eb;
    border-radius: 0.5rem;
    font-size: 0.875rem;
    transition: all 0.2s;
}
.ai-checkout-page input:focus,
.ai-checkout-page select:focus,
.ai-checkout-page textarea:focus {
    outline: none;
    border-color: var(--color-primary, #3b82f6);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}
.ai-checkout-page label {
    display: block;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #374151;
}
.ai-checkout-page .form-row {
    margin-bottom: 1rem;
}
.ai-checkout-page .form-row-first,
.ai-checkout-page .form-row-last {
    width: calc(50% - 0.5rem);
    display: inline-block;
}
.ai-checkout-page .form-row-first {
    margin-right: 0.5rem;
}
.ai-checkout-page .form-row-last {
    margin-left: 0.5rem;
}
.ai-checkout-page .required {
    color: #ef4444;
}

/* Order review */
.ai-checkout-page .woocommerce-checkout-review-order-table {
    width: 100%;
    margin-bottom: 1.5rem;
}
.ai-checkout-page .woocommerce-checkout-review-order-table th,
.ai-checkout-page .woocommerce-checkout-review-order-table td {
    padding: 0.75rem 0;
    border-bottom: 1px solid #f3f4f6;
    text-align: left;
}
.ai-checkout-page .woocommerce-checkout-review-order-table thead th {
    font-weight: 600;
    color: #6b7280;
    font-size: 0.75rem;
    text-transform: uppercase;
}
.ai-checkout-page .woocommerce-checkout-review-order-table .cart_item td {
    font-size: 0.875rem;
}
.ai-checkout-page .woocommerce-checkout-review-order-table .product-name {
    color: #111827;
}
.ai-checkout-page .woocommerce-checkout-review-order-table .product-total {
    text-align: right;
    font-weight: 500;
}
.ai-checkout-page .woocommerce-checkout-review-order-table tfoot th {
    font-weight: 500;
    color: #374151;
}
.ai-checkout-page .woocommerce-checkout-review-order-table tfoot td {
    text-align: right;
    font-weight: 500;
}
.ai-checkout-page .woocommerce-checkout-review-order-table .order-total th,
.ai-checkout-page .woocommerce-checkout-review-order-table .order-total td {
    font-size: 1.125rem;
    font-weight: 700;
    color: #111827;
    border-bottom: none;
    padding-top: 1rem;
}

/* Payment methods */
.ai-checkout-page .wc_payment_methods {
    list-style: none;
    padding: 0;
    margin: 0 0 1.5rem 0;
}
.ai-checkout-page .wc_payment_method {
    padding: 1rem;
    margin-bottom: 0.5rem;
    border: 1px solid #e5e7eb;
    border-radius: 0.5rem;
    transition: all 0.2s;
}
.ai-checkout-page .wc_payment_method:has(input:checked) {
    border-color: var(--color-primary, #3b82f6);
    background: #f0f9ff;
}
.ai-checkout-page .wc_payment_method label {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin: 0;
    cursor: pointer;
    font-weight: 500;
}
.ai-checkout-page .wc_payment_method input[type="radio"] {
    width: 1.25rem;
    height: 1.25rem;
}
.ai-checkout-page .payment_box {
    margin-top: 0.75rem;
    padding: 0.75rem;
    background: #f9fafb;
    border-radius: 0.375rem;
    font-size: 0.875rem;
    color: #6b7280;
}

/* Place order button */
.ai-checkout-page #place_order {
    width: 100%;
    padding: 1rem 1.5rem;
    background: var(--color-primary, #3b82f6);
    color: white;
    font-weight: 600;
    font-size: 1rem;
    border: none;
    border-radius: 0.75rem;
    cursor: pointer;
    transition: opacity 0.2s;
}
.ai-checkout-page #place_order:hover {
    opacity: 0.9;
}
.ai-checkout-page #place_order:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

/* Terms */
.ai-checkout-page .woocommerce-terms-and-conditions-wrapper {
    margin-bottom: 1rem;
    font-size: 0.875rem;
    color: #6b7280;
}
.ai-checkout-page .woocommerce-terms-and-conditions-wrapper a {
    color: var(--color-primary, #3b82f6);
}

/* Validation */
.ai-checkout-page .woocommerce-invalid input,
.ai-checkout-page .woocommerce-invalid select {
    border-color: #ef4444;
}
.ai-checkout-page .woocommerce-validated input,
.ai-checkout-page .woocommerce-validated select {
    border-color: #10b981;
}

/* Responsive */
@media (max-width: 640px) {
    .ai-checkout-page .form-row-first,
    .ai-checkout-page .form-row-last {
        width: 100%;
        display: block;
        margin: 0 0 1rem 0;
    }
}

/* Shipping methods */
.ai-checkout-page .woocommerce-shipping-methods {
    list-style: none;
    padding: 0;
    margin: 0;
}
.ai-checkout-page .woocommerce-shipping-methods li {
    padding: 0.75rem;
    border: 1px solid #e5e7eb;
    border-radius: 0.5rem;
    margin-bottom: 0.5rem;
}
.ai-checkout-page .woocommerce-shipping-methods li label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
    cursor: pointer;
}
</style>
