<?php
/**
 * My Account Page Template
 *
 * Custom styled my-account page for AI Theme
 * Design based on frontend profile page
 *
 * @package AI_Theme
 */

defined('ABSPATH') || exit;

$current_user = wp_get_current_user();

// Get AI-generated texts with fallbacks
$my_account_title = ai_get_text('profile.myAccount', ai_get_label('account.title', 'My Account'));
$home_text = ai_get_text('common.home', ai_get_label('general.home', 'Home'));
?>

<div class="ai-my-account-page py-8 md:py-12" data-theme="<?php echo esc_attr(get_option('ai_theme_style', 'modern')); ?>">
    <div class="ai-container">

        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2"><?php echo esc_html($my_account_title); ?></h1>
            <nav class="text-sm">
                <a href="<?php echo esc_url(home_url('/')); ?>" class="text-primary hover:opacity-80 transition-opacity"><?php echo esc_html($home_text); ?></a>
                <span class="text-gray-400 mx-2">/</span>
                <span class="text-gray-500"><?php echo esc_html($my_account_title); ?></span>
            </nav>
        </div>

        <?php do_action('woocommerce_before_account_navigation'); ?>

        <div class="ai-account-layout">
            <!-- Left Sidebar -->
            <div class="ai-account-sidebar-wrapper">
                <div class="ai-account-sidebar">
                    <!-- User Avatar & Info -->
                    <div class="ai-account-user-info">
                        <div class="ai-account-avatar">
                            <span><?php echo esc_html(mb_strtoupper(mb_substr($current_user->display_name ?: $current_user->user_login, 0, 1))); ?></span>
                        </div>
                        <h2 class="ai-account-username"><?php echo esc_html($current_user->display_name ?: $current_user->user_login); ?></h2>
                        <p class="ai-account-email"><?php echo esc_html($current_user->user_email); ?></p>
                    </div>

                    <!-- Navigation Menu -->
                    <nav class="woocommerce-MyAccount-navigation">
                        <ul class="ai-account-menu">
                            <?php foreach (wc_get_account_menu_items() as $endpoint => $label) :
                                $url = wc_get_account_endpoint_url($endpoint);
                                $is_active = wc_is_current_account_menu_item($endpoint);
                                $icon = ai_theme_get_account_menu_icon($endpoint);
                                $is_logout = ($endpoint === 'customer-logout');
                            ?>
                            <li class="<?php echo esc_attr('woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--' . $endpoint); ?>">
                                <a href="<?php echo esc_url($url); ?>" class="ai-account-menu-item <?php echo $is_active ? 'active' : ''; ?> <?php echo $is_logout ? 'logout' : ''; ?>">
                                    <?php echo $icon; ?>
                                    <span><?php echo esc_html($label); ?></span>
                                </a>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </nav>
                </div>
            </div>

            <!-- Right Content Area -->
            <div class="ai-account-content-wrapper">
                <div class="ai-account-content">
                    <div class="woocommerce-MyAccount-content">
                        <?php
                        /**
                         * My Account content.
                         *
                         * @since 2.6.0
                         */
                        do_action('woocommerce_account_content');
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <?php do_action('woocommerce_after_account_navigation'); ?>
    </div>
</div>

<?php
/**
 * Get icon for account menu item
 */
function ai_theme_get_account_menu_icon($endpoint) {
    $icons = array(
        'dashboard' => '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><rect x="3" y="3" width="7" height="7" rx="1" stroke-width="2"/><rect x="14" y="3" width="7" height="7" rx="1" stroke-width="2"/><rect x="3" y="14" width="7" height="7" rx="1" stroke-width="2"/><rect x="14" y="14" width="7" height="7" rx="1" stroke-width="2"/></svg>',
        'orders' => '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/></svg>',
        'downloads' => '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/></svg>',
        'edit-address' => '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><circle cx="12" cy="11" r="3" stroke-width="2"/></svg>',
        'payment-methods' => '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/></svg>',
        'edit-account' => '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle cx="12" cy="8" r="4" stroke-width="2"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 21v-2a4 4 0 014-4h4a4 4 0 014 4v2"/></svg>',
        'customer-logout' => '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/></svg>',
    );

    return isset($icons[$endpoint]) ? $icons[$endpoint] : '<svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>';
}
?>

<style>
/* ================================================
   AI Theme - My Account Page Styles
   Based on frontend profile page design
   ================================================ */

/* Main layout - flexbox (Tailwind classes don't work in WP) */
.ai-my-account-page .ai-account-layout {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}
@media (min-width: 1024px) {
    .ai-my-account-page .ai-account-layout {
        flex-direction: row;
    }
}

/* Sidebar */
.ai-my-account-page .ai-account-sidebar-wrapper {
    flex-shrink: 0;
}
@media (min-width: 1024px) {
    .ai-my-account-page .ai-account-sidebar-wrapper {
        width: 288px;
    }
}

/* Content area */
.ai-my-account-page .ai-account-content-wrapper {
    flex: 1;
    min-width: 0; /* Prevent flex overflow */
}

/* Sidebar styling */
.ai-my-account-page .ai-account-sidebar {
    border: 2px dashed #e5e7eb;
    border-radius: 0.5rem;
    padding: 1.5rem;
}

/* Content area styling */
.ai-my-account-page .ai-account-content {
    border: 2px dashed #e5e7eb;
    border-radius: 0.5rem;
    padding: 1.5rem;
}
@media (min-width: 768px) {
    .ai-my-account-page .ai-account-content {
        padding: 2rem;
    }
}

/* User Info Section */
.ai-my-account-page .ai-account-user-info {
    display: flex;
    flex-direction: column;
    align-items: center;
    margin-bottom: 1.5rem;
}

/* Avatar with primary color background */
.ai-my-account-page .ai-account-avatar {
    width: 96px;
    height: 96px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 0.75rem;
    background-color: rgba(var(--color-primary-rgb, 59, 130, 246), 0.1);
}
.ai-my-account-page .ai-account-avatar span {
    font-size: 2.25rem;
    font-weight: 600;
    color: #374151;
}

.ai-my-account-page .ai-account-username {
    font-size: 1.125rem;
    font-weight: 600;
    color: #111827;
    margin: 0 0 0.25rem 0;
}

.ai-my-account-page .ai-account-email {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0;
}

/* Menu */
.ai-my-account-page .ai-account-menu {
    list-style: none;
    padding: 0;
    margin: 0;
}
.ai-my-account-page .ai-account-menu li {
    margin-bottom: 0.25rem;
}

/* Menu item base styles */
.ai-my-account-page .ai-account-menu-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 1rem;
    border-radius: 0.5rem;
    color: #4b5563;
    text-decoration: none;
    transition: all 0.2s;
    font-weight: 500;
    white-space: nowrap; /* Prevent text wrap */
}
.ai-my-account-page .ai-account-menu-item:hover {
    background-color: #f9fafb;
}
.ai-my-account-page .ai-account-menu-item svg {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

/* Active menu item - with left border accent */
.ai-my-account-page .ai-account-menu-item.active {
    color: var(--color-primary, #3b82f6);
    background-color: rgba(var(--color-primary-rgb, 59, 130, 246), 0.1);
    border-left: 4px solid var(--color-primary, #3b82f6);
    margin-left: -2px;
    padding-left: 14px;
}

/* Logout item - red color */
.ai-my-account-page .ai-account-menu-item.logout {
    color: #ef4444 !important;
}
.ai-my-account-page .ai-account-menu-item.logout:hover {
    background-color: #fef2f2 !important;
}

/* ================================================
   Content Area - General Styles
   ================================================ */

/* Headings */
.ai-my-account-page .woocommerce-MyAccount-content h2,
.ai-my-account-page .woocommerce-MyAccount-content h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: #111827;
    margin-bottom: 1rem;
}

/* Paragraphs and links */
.ai-my-account-page .woocommerce-MyAccount-content > p:first-child {
    font-size: 1rem;
    color: #6b7280;
    margin-bottom: 1.5rem;
}
.ai-my-account-page .woocommerce-MyAccount-content a {
    color: var(--color-primary, #3b82f6);
}
.ai-my-account-page .woocommerce-MyAccount-content a:hover {
    opacity: 0.8;
}

/* ================================================
   Addresses Section - Two Column Grid
   ================================================ */

.ai-my-account-page .woocommerce-Addresses,
.ai-my-account-page .col2-set.addresses,
.ai-my-account-page .u-columns.woocommerce-Addresses {
    display: grid !important;
    grid-template-columns: 1fr !important; /* Stack on small screens */
    gap: 1rem !important;
}
@media (min-width: 640px) {
    .ai-my-account-page .woocommerce-Addresses,
    .ai-my-account-page .col2-set.addresses,
    .ai-my-account-page .u-columns.woocommerce-Addresses {
        grid-template-columns: repeat(2, 1fr) !important;
        gap: 1.5rem !important;
    }
}

/* Remove WooCommerce default clearfix pseudo-elements that break grid */
.ai-my-account-page .col2-set::before,
.ai-my-account-page .col2-set::after,
.ai-my-account-page .u-columns::before,
.ai-my-account-page .u-columns::after,
.ai-my-account-page .woocommerce-Addresses::before,
.ai-my-account-page .woocommerce-Addresses::after {
    display: none !important;
    content: none !important;
}
.ai-my-account-page .col2-set .col-1,
.ai-my-account-page .col2-set .col-2,
.ai-my-account-page .u-column1,
.ai-my-account-page .u-column2 {
    float: none !important;
    width: 100% !important;
    margin: 0 !important;
    padding: 0 !important;
    max-width: none !important;
}

/* Address card styling */
.ai-my-account-page .woocommerce-Address {
    padding: 1.5rem;
    background: #f9fafb;
    border-radius: 0.75rem;
    border: 1px solid #e5e7eb;
}

/* Address title row */
.ai-my-account-page .woocommerce-Address-title,
.ai-my-account-page .woocommerce-Address-title.title {
    display: flex !important;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
    flex-wrap: wrap;
    gap: 0.5rem;
}
.ai-my-account-page .woocommerce-Address-title h2,
.ai-my-account-page .woocommerce-Address-title h3 {
    font-size: 1rem !important;
    font-weight: 600 !important;
    margin: 0 !important;
    color: #111827;
}
.ai-my-account-page .woocommerce-Address-title a,
.ai-my-account-page .woocommerce-Address-title a.edit {
    font-size: 0.875rem;
    color: var(--color-primary, #3b82f6);
    text-decoration: none;
}
.ai-my-account-page .woocommerce-Address-title a:hover {
    opacity: 0.8;
}

/* Address text */
.ai-my-account-page .woocommerce-Address address {
    font-style: normal;
    color: #6b7280;
    line-height: 1.6;
}

/* Responsive: Stack on mobile */
@media (max-width: 768px) {
    .ai-my-account-page .woocommerce-Addresses,
    .ai-my-account-page .col2-set.addresses,
    .ai-my-account-page .u-columns.woocommerce-Addresses {
        grid-template-columns: 1fr !important;
    }
}

/* ================================================
   Orders Table
   ================================================ */

.ai-my-account-page .woocommerce-orders-table {
    width: 100%;
    border-collapse: collapse;
}
.ai-my-account-page .woocommerce-orders-table thead th {
    padding: 0.75rem 1rem;
    background: #f9fafb;
    font-weight: 600;
    font-size: 0.75rem;
    text-transform: uppercase;
    color: #6b7280;
    text-align: left;
    border-bottom: 1px solid #e5e7eb;
}
.ai-my-account-page .woocommerce-orders-table tbody td {
    padding: 1rem;
    border-bottom: 1px solid #f3f4f6;
    vertical-align: middle;
}
.ai-my-account-page .woocommerce-orders-table .woocommerce-orders-table__cell-order-number a {
    font-weight: 600;
    color: #111827;
}
.ai-my-account-page .woocommerce-orders-table .woocommerce-orders-table__cell-order-actions a {
    display: inline-block;
    padding: 0.5rem 1rem;
    background: #f3f4f6;
    color: #374151;
    font-size: 0.875rem;
    font-weight: 500;
    border-radius: 0.375rem;
    transition: all 0.2s;
    margin-right: 0.5rem;
    margin-bottom: 0.25rem;
    text-decoration: none;
}
.ai-my-account-page .woocommerce-orders-table .woocommerce-orders-table__cell-order-actions a:hover {
    background: #e5e7eb;
}

/* Empty orders message */
.ai-my-account-page .woocommerce-message--info,
.ai-my-account-page .woocommerce-info {
    text-align: center;
    padding: 3rem 1.5rem;
    color: #6b7280;
}

/* ================================================
   Forms - Account Details, Edit Address
   ================================================ */

.ai-my-account-page form .form-row {
    margin-bottom: 1rem;
}
.ai-my-account-page form label {
    display: block;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #374151;
}
.ai-my-account-page form label .required {
    color: #ef4444;
}

/* Input fields */
.ai-my-account-page form input[type="text"],
.ai-my-account-page form input[type="email"],
.ai-my-account-page form input[type="tel"],
.ai-my-account-page form input[type="password"],
.ai-my-account-page form select,
.ai-my-account-page form textarea {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 1px solid #d1d5db;
    border-radius: 0.5rem;
    font-size: 0.875rem;
    transition: all 0.2s;
    background: white;
}
.ai-my-account-page form input:focus,
.ai-my-account-page form select:focus,
.ai-my-account-page form textarea:focus {
    outline: none;
    border-color: var(--color-primary, #3b82f6);
    box-shadow: 0 0 0 3px rgba(var(--color-primary-rgb, 59, 130, 246), 0.1);
}

/* Two-column form rows */
.ai-my-account-page form .form-row-first,
.ai-my-account-page form .form-row-last {
    width: calc(50% - 0.75rem);
    display: inline-block;
    vertical-align: top;
}
.ai-my-account-page form .form-row-first {
    margin-right: 0.75rem;
}
.ai-my-account-page form .form-row-last {
    margin-left: 0.75rem;
}
@media (max-width: 640px) {
    .ai-my-account-page form .form-row-first,
    .ai-my-account-page form .form-row-last {
        width: 100%;
        display: block;
        margin: 0 0 1rem 0;
    }
}

/* Submit button */
.ai-my-account-page form button[type="submit"],
.ai-my-account-page form .button,
.ai-my-account-page .woocommerce-Button {
    display: inline-block;
    padding: 0.75rem 2rem;
    background: var(--color-primary, #3b82f6);
    color: white !important;
    font-weight: 600;
    font-size: 0.875rem;
    border: none;
    border-radius: 0.5rem;
    cursor: pointer;
    transition: opacity 0.2s;
    text-decoration: none;
}
.ai-my-account-page form button[type="submit"]:hover,
.ai-my-account-page form .button:hover,
.ai-my-account-page .woocommerce-Button:hover {
    opacity: 0.9;
}

/* ================================================
   Messages - Info, Success, Error
   ================================================ */

.ai-my-account-page .woocommerce-message,
.ai-my-account-page .woocommerce-info {
    padding: 1rem 1.5rem;
    background: rgba(var(--color-primary-rgb, 59, 130, 246), 0.1);
    border-left: 4px solid var(--color-primary, #3b82f6);
    border-radius: 0 0.5rem 0.5rem 0;
    margin-bottom: 1.5rem;
    color: #1e40af;
}
.ai-my-account-page .woocommerce-error {
    padding: 1rem 1.5rem;
    background: #fef2f2;
    border-left: 4px solid #ef4444;
    border-radius: 0 0.5rem 0.5rem 0;
    margin-bottom: 1.5rem;
    color: #b91c1c;
}
.ai-my-account-page .woocommerce-error li {
    list-style: none;
}

/* ================================================
   Order Details Page
   ================================================ */

.ai-my-account-page .woocommerce-order-details {
    margin-bottom: 2rem;
}
.ai-my-account-page .woocommerce-order-details__title {
    font-size: 1.125rem;
    font-weight: 600;
    margin-bottom: 1rem;
}
.ai-my-account-page .woocommerce-table--order-details {
    width: 100%;
    border-collapse: collapse;
}
.ai-my-account-page .woocommerce-table--order-details th,
.ai-my-account-page .woocommerce-table--order-details td {
    padding: 0.75rem;
    border-bottom: 1px solid #e5e7eb;
    text-align: left;
}
.ai-my-account-page .woocommerce-table--order-details thead th {
    background: #f9fafb;
    font-weight: 600;
    font-size: 0.875rem;
}

/* ================================================
   Password visibility toggle (for edit-account)
   ================================================ */

.ai-my-account-page .password-input {
    position: relative;
}
.ai-my-account-page .password-input input {
    padding-right: 3rem;
}
.ai-my-account-page .show-password-input {
    position: absolute;
    right: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: #9ca3af;
    cursor: pointer;
    padding: 0.25rem;
}
.ai-my-account-page .show-password-input:hover {
    color: #6b7280;
}

/* ================================================
   Responsive Layout
   ================================================ */

@media (max-width: 1024px) {
    .ai-my-account-page .flex-col.lg\\:flex-row {
        flex-direction: column;
    }
    .ai-my-account-page .lg\\:w-72 {
        width: 100%;
    }
}
</style>
