<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class About_Minimal extends AI_Widget_Base {

    public function get_name() { return 'ai_about_minimal'; }
    public function get_title() { return __('About Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-text'; }
    public function get_categories() { return array('ai-theme-about'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('navigation.labels.about', '');
        ?>
        <section class="ai-about ai-about-minimal py-32 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="about" data-block-variant="about-minimal">
            <div class="ai-container-narrow text-center space-y-6">
                <h2 class="ai-about-title text-5xl font-bold text-[var(--text-primary)]"><?php echo esc_html($title); ?></h2>
                <p class="ai-about-description text-xl text-[var(--text-secondary)] leading-relaxed"><?php echo esc_html($s['description']); ?></p>
            </div>
        </section>
        <?php
    }
}
