<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class About_Timeline extends AI_Widget_Base {
    public function get_name() { return 'ai_about_timeline'; }
    public function get_title() { return __('About Timeline', 'ai-theme'); }
    public function get_icon() { return 'eicon-time-line'; }
    public function get_categories() { return array('ai-theme-about'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('year', array('label' => __('Year', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));

        $this->add_control('milestones', array('label' => __('Milestones', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-20 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="about" data-block-variant="about-timeline">
            <div class="max-w-4xl mx-auto px-6">
                <h2 class="text-3xl font-bold text-[var(--text-primary)] text-center mb-12"><?php echo esc_html($settings['heading']); ?></h2>
                <div class="relative">
                    <div class="absolute left-4 md:left-1/2 top-0 bottom-0 w-0.5 bg-[var(--border-color)] md:-translate-x-1/2"></div>
                    <div class="space-y-8">
                        <?php foreach ($settings['milestones'] as $idx => $item) : ?>
                            <div class="relative flex items-start gap-8 <?php echo $idx % 2 === 0 ? 'md:flex-row-reverse' : ''; ?>">
                                <div class="flex-1 <?php echo $idx % 2 === 0 ? 'md:text-right' : ''; ?>">
                                    <div class="bg-[var(--bg-primary)] rounded-[var(--card-radius)] p-6 shadow-sm ml-12 md:ml-0">
                                        <span class="text-[var(--primary)] font-bold"><?php echo esc_html($item['year']); ?></span>
                                        <h3 class="font-bold text-[var(--text-primary)] mt-1"><?php echo esc_html($item['title']); ?></h3>
                                        <p class="text-sm text-[var(--text-secondary)] mt-2"><?php echo esc_html($item['description']); ?></p>
                                    </div>
                                </div>
                                <div class="absolute left-0 md:left-1/2 w-8 h-8 bg-[var(--primary)] rounded-full flex items-center justify-center md:-translate-x-1/2 z-10">
                                    <div class="w-3 h-3 bg-white rounded-full"></div>
                                </div>
                                <div class="hidden md:block flex-1"></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
