<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Breadcrumbs_Simple extends AI_Widget_Base {
    public function get_name() { return 'ai_breadcrumbs_simple'; }
    public function get_title() { return __('Breadcrumbs Simple', 'ai-theme'); }
    public function get_icon() { return 'eicon-post-navigation'; }
    public function get_categories() { return array('ai-theme-breadcrumbs'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('separator', ['label' => __('Separator', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '/']);

        $repeater = new Repeater();
        $repeater->add_control('text', ['label' => __('Text', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('link', ['label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL]);
        $this->add_control('items', ['label' => __('Breadcrumbs', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $sep = esc_html($s['separator']);
        $total = count($s['items']);
        ?>
        <nav class="ai-breadcrumbs ai-breadcrumbs-simple w-full bg-[var(--bg-secondary)] py-4" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="breadcrumbs" data-block-variant="breadcrumbs-simple" aria-label="Breadcrumb">
            <div class="ai-container">
                <ol class="flex items-center flex-wrap gap-2 text-sm">
                    <?php foreach ($s['items'] as $i => $item) : ?>
                        <li class="flex items-center gap-2">
                            <?php if ($i < $total - 1 && !empty($item['link']['url'])) : ?>
                                <a href="<?php echo esc_url($item['link']['url']); ?>" class="text-[var(--text-secondary)] hover:text-[var(--text-primary)] transition-colors hover:underline"><?php echo esc_html($item['text']); ?></a>
                                <span class="ai-breadcrumbs-sep text-[var(--text-muted)]" aria-hidden="true"><?php echo $sep; ?></span>
                            <?php else : ?>
                                <span class="ai-breadcrumbs-current text-[var(--text-primary)] font-medium" aria-current="page"><?php echo esc_html($item['text']); ?></span>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                </ol>
            </div>
        </nav>
        <?php
    }
}
