<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cases_Grid extends AI_Widget_Base {
    public function get_name() { return 'ai_cases_grid'; }
    public function get_title() { return __('Cases Grid', 'ai-theme'); }
    public function get_icon() { return 'eicon-posts-grid'; }
    public function get_categories() { return array('ai-theme-cases'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('view_case_text', ['label' => __('View Case Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('client', ['label' => __('Client', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('industry', ['label' => __('Industry', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('stat_metric', ['label' => __('Stat Metric', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'description' => 'e.g. +45%']);
        $repeater->add_control('stat_label', ['label' => __('Stat Label', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('link', ['label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL]);

        $this->add_control('cases', ['label' => __('Cases', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $cases = $s['cases'] ?? [];
        ?>
        <section class="section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cases" data-block-variant="cases-grid">
            <div class="max-w-7xl mx-auto px-6">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)]"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <div class="grid md:grid-cols-2 gap-8">
                    <?php foreach ($cases as $case) : ?>
                    <div class="group bg-[var(--bg-primary)] rounded-2xl overflow-hidden border-2 border-[var(--border-color,#e5e7eb)] hover:border-[var(--primary)] hover:shadow-2xl transition-all">
                        <?php if (!empty($case['image']['url'])) : ?>
                        <div class="relative overflow-hidden">
                            <img src="<?php echo esc_url($case['image']['url']); ?>" alt="<?php echo esc_attr($case['title']); ?>" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-500">
                            <?php if (!empty($case['industry'])) : ?>
                            <div class="absolute top-4 right-4 bg-[var(--bg-primary)] px-4 py-2 rounded-full text-sm font-semibold text-[var(--text-primary)]">
                                <?php echo esc_html($case['industry']); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        <div class="p-8">
                            <h3 class="text-2xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($case['title']); ?></h3>
                            <?php if (!empty($case['client'])) : ?>
                            <p class="text-[var(--primary)] font-semibold mb-4"><?php echo esc_html($case['client']); ?></p>
                            <?php endif; ?>
                            <?php if (!empty($case['description'])) : ?>
                            <p class="text-[var(--text-secondary)] mb-6"><?php echo esc_html($case['description']); ?></p>
                            <?php endif; ?>
                            <div class="flex items-center justify-between">
                                <?php if (!empty($case['stat_metric'])) : ?>
                                <div class="text-center">
                                    <div class="text-3xl font-bold text-[var(--primary)]"><?php echo esc_html($case['stat_metric']); ?></div>
                                    <?php if (!empty($case['stat_label'])) : ?>
                                    <div class="text-sm text-[var(--text-muted)]"><?php echo esc_html($case['stat_label']); ?></div>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($case['link']['url'])) : ?>
                                <a href="<?php echo esc_url($case['link']['url']); ?>" class="inline-flex items-center gap-2 text-[var(--primary)] font-semibold hover:gap-3 transition-all">
                                    <?php echo esc_html($s['view_case_text']); ?>
                                    <span class="text-xl">→</span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
