<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cases_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_cases_minimal'; }
    public function get_title() { return __('Cases Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-bullet-list'; }
    public function get_categories() { return array('ai-theme-cases'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('client', ['label' => __('Client', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('industry', ['label' => __('Industry', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('stat_metric', ['label' => __('Stat Metric', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('stat_label', ['label' => __('Stat Label', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('link', ['label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL]);

        $this->add_control('cases', ['label' => __('Cases', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $cases = $s['cases'] ?? [];
        ?>
        <section class="py-16 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cases" data-block-variant="cases-minimal">
            <div class="max-w-4xl mx-auto px-6">
                <?php if (!empty($s['heading'])) : ?>
                <h2 class="text-3xl font-bold text-[var(--text-primary)] text-center mb-2"><?php echo esc_html($s['heading']); ?></h2>
                <?php endif; ?>
                <?php if (!empty($s['subheading'])) : ?>
                <p class="text-[var(--text-secondary)] text-center mb-12"><?php echo esc_html($s['subheading']); ?></p>
                <?php endif; ?>

                <div class="divide-y divide-[var(--border-color,#e5e7eb)]">
                    <?php foreach ($cases as $case) :
                        $url = !empty($case['link']['url']) ? $case['link']['url'] : '#';
                    ?>
                    <a href="<?php echo esc_url($url); ?>" class="group flex items-center justify-between py-6 hover:bg-[var(--bg-secondary)] -mx-6 px-6 transition-colors">
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-1">
                                <h3 class="text-xl font-semibold text-[var(--text-primary)] group-hover:text-[var(--primary)] transition-colors">
                                    <?php echo esc_html($case['title']); ?>
                                </h3>
                                <?php if (!empty($case['industry'])) : ?>
                                <span class="px-2 py-0.5 bg-[var(--bg-secondary)] text-[var(--text-muted)] text-xs rounded-full">
                                    <?php echo esc_html($case['industry']); ?>
                                </span>
                                <?php endif; ?>
                            </div>
                            <?php if (!empty($case['client'])) : ?>
                            <p class="text-sm text-[var(--primary)] mb-1"><?php echo esc_html($case['client']); ?></p>
                            <?php endif; ?>
                            <?php if (!empty($case['description'])) : ?>
                            <p class="text-[var(--text-muted)] text-sm line-clamp-1"><?php echo esc_html($case['description']); ?></p>
                            <?php endif; ?>
                        </div>

                        <div class="flex items-center gap-6 ml-4">
                            <?php if (!empty($case['stat_metric'])) : ?>
                            <div class="text-right">
                                <div class="text-2xl font-bold text-[var(--primary)]"><?php echo esc_html($case['stat_metric']); ?></div>
                                <?php if (!empty($case['stat_label'])) : ?>
                                <div class="text-xs text-[var(--text-muted)]"><?php echo esc_html($case['stat_label']); ?></div>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                            <svg class="w-5 h-5 text-[var(--text-muted)] group-hover:text-[var(--primary)] group-hover:translate-x-1 transition-all" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                        </div>
                    </a>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
