<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Categories_Grid extends AI_Widget_Base {
    public function get_name() { return 'ai_categories_grid'; }
    public function get_title() { return __('Categories Grid', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-grid'; }
    public function get_categories() { return array('ai-theme-categories'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);
        $this->add_control('use_woocommerce', ['label' => __('Use WooCommerce Categories', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes']);
        $this->add_control('count', ['label' => __('Count', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 8]);
        $this->add_control('columns', ['label' => __('Columns', 'ai-theme'), 'type' => Controls_Manager::SELECT, 'default' => '4', 'options' => ['2' => '2', '3' => '3', '4' => '4']]);
        $this->add_control('show_count', ['label' => __('Show Product Count', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes']);
        $this->add_control('show_description', ['label' => __('Show Description', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes']);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        
        if ($settings['use_woocommerce'] === 'yes' && class_exists('WooCommerce')) {
            $categories = get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false, 'number' => intval($settings['count'])));
        } else {
            $categories = get_categories(array('number' => intval($settings['count'])));
        }

        $cols = intval($settings['columns']);
        $grid_class = 'grid-cols-1 md:grid-cols-2';
        if ($cols === 3) $grid_class = 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3';
        if ($cols === 4) $grid_class = 'grid-cols-1 md:grid-cols-2 lg:grid-cols-4';
        ?>
        <section class="py-16 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="categories" data-block-variant="categories-grid">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Grid -->
                <div class="grid <?php echo esc_attr($grid_class); ?> gap-6">
                    <?php foreach ($categories as $cat) : 
                        $link = get_term_link($cat);
                        $thumb_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
                        $image = $thumb_id ? wp_get_attachment_image_url($thumb_id, 'medium') : '';
                        $description = $cat->description ?? '';
                    ?>
                    <a href="<?php echo esc_url($link); ?>" class="group relative bg-[var(--bg-primary)] rounded-xl overflow-hidden shadow-sm hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                        <!-- Image -->
                        <div class="relative h-48 overflow-hidden bg-[var(--bg-secondary)]">
                            <?php if ($image) : ?>
                            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($cat->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" />
                            <?php else : ?>
                            <div class="w-full h-full flex items-center justify-center bg-gradient-to-br from-blue-500 to-purple-600">
                                <svg class="w-20 h-20 text-white opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                </svg>
                            </div>
                            <?php endif; ?>

                            <!-- Overlay -->
                            <div class="absolute inset-0 bg-black/0 group-hover:bg-black/20 transition-all duration-300"></div>

                            <!-- Count badge -->
                            <?php if ($settings['show_count'] === 'yes') : ?>
                            <div class="absolute top-4 right-4 bg-[var(--bg-primary)] rounded-full px-3 py-1 shadow-md">
                                <span class="text-sm font-semibold text-[var(--text-primary)]"><?php echo $cat->count; ?> <?php _e('products', 'ai-theme'); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Info -->
                        <div class="p-6">
                            <div class="flex items-start justify-between gap-2 mb-2">
                                <h3 class="text-xl font-bold text-[var(--text-primary)] group-hover:text-[var(--primary)] transition-colors"><?php echo esc_html($cat->name); ?></h3>
                                <svg class="w-5 h-5 text-[var(--text-muted)] group-hover:text-[var(--primary)] group-hover:translate-x-1 transition-all flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </div>

                            <?php if ($settings['show_description'] === 'yes' && $description) : ?>
                            <p class="text-[var(--text-secondary)] text-sm line-clamp-2"><?php echo esc_html($description); ?></p>
                            <?php endif; ?>
                        </div>

                        <!-- Bottom indicator -->
                        <div class="absolute bottom-0 left-0 right-0 h-1 bg-gradient-to-r from-blue-600 to-purple-600 transform scale-x-0 group-hover:scale-x-100 transition-transform duration-300 origin-left"></div>
                    </a>
                    <?php endforeach; ?>
                </div>

                <!-- Empty State -->
                <?php if (empty($categories)) : ?>
                <div class="text-center py-16">
                    <svg class="w-16 h-16 text-[var(--text-muted)] mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                    <h3 class="text-xl font-semibold text-[var(--text-primary)] mb-2"><?php _e('No categories found', 'ai-theme'); ?></h3>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
