<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Contact_Centered extends AI_Widget_Base {
    public function get_name() { return 'ai_contact_centered'; }
    public function get_title() { return __('Contact Centered', 'ai-theme'); }
    public function get_icon() { return 'eicon-envelope'; }
    public function get_categories() { return array('ai-theme-contact'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subtitle', ['label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('phone', ['label' => __('Phone', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('email', ['label' => __('Email', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('address', ['label' => __('Address', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('name_placeholder', ['label' => __('Name Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('email_placeholder', ['label' => __('Email Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('message_placeholder', ['label' => __('Message Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('submit_text', ['label' => __('Submit Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        
        // Labels from siteTexts (paths aligned with React components)
        $labels = [
            'name' => ai_get_text('forms.labels.name', ''),
            'email' => ai_get_text('forms.labels.email', 'Email'),
            'message' => ai_get_text('forms.labels.message', ''),
            'send' => ai_get_text('forms.buttons.send', ''),
            'privacy' => ai_get_text('modals.contact.consentText', ''),
            'privacyLink' => ai_get_text('legal.privacy.title', '')
        ];
        
        $namePlaceholder = !empty($s['name_placeholder']) ? $s['name_placeholder'] : ai_get_text('forms.placeholders.name', '');
        $emailPlaceholder = !empty($s['email_placeholder']) ? $s['email_placeholder'] : ai_get_text('forms.placeholders.email', '');
        $messagePlaceholder = !empty($s['message_placeholder']) ? $s['message_placeholder'] : ai_get_text('forms.placeholders.message', '');
        $submitText = !empty($s['submit_text']) ? $s['submit_text'] : $labels['send'];
        
        $inputClass = "w-full px-4 py-3 bg-[var(--bg-secondary)] border border-[var(--border-color,#e5e7eb)] rounded-lg text-[var(--text-primary)] placeholder-[var(--text-muted)] focus:outline-none focus:ring-2 focus:ring-[var(--primary)] focus:border-transparent transition-all";
        ?>
        <section class="py-20 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="contact" data-block-variant="contact-centered">
            <div class="max-w-xl mx-auto px-6">
                <!-- Header -->
                <div class="text-center mb-10">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($s['title']); ?></h2>
                    <?php if (!empty($s['subtitle'])) : ?>
                    <p class="text-[var(--text-secondary)]"><?php echo esc_html($s['subtitle']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Form -->
                <div class="bg-[var(--bg-primary)] rounded-2xl shadow-lg border border-[var(--border-color,#e5e7eb)] p-8">
                    <div class="space-y-5">
                        <div>
                            <label class="block text-sm font-medium text-[var(--text-secondary)] mb-2">
                                <?php echo esc_html($labels['name']); ?> <span class="text-red-500">*</span>
                            </label>
                            <input type="text" placeholder="<?php echo esc_attr($namePlaceholder); ?>" class="<?php echo esc_attr($inputClass); ?>" required />
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-[var(--text-secondary)] mb-2">
                                <?php echo esc_html($labels['email']); ?> <span class="text-red-500">*</span>
                            </label>
                            <input type="email" placeholder="<?php echo esc_attr($emailPlaceholder); ?>" class="<?php echo esc_attr($inputClass); ?>" required />
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-[var(--text-secondary)] mb-2">
                                <?php echo esc_html($labels['message']); ?> <span class="text-red-500">*</span>
                            </label>
                            <textarea placeholder="<?php echo esc_attr($messagePlaceholder); ?>" rows="4" class="<?php echo esc_attr($inputClass); ?> resize-none" required></textarea>
                        </div>

                        <!-- Privacy Checkbox -->
                        <div class="flex items-start gap-3 p-4 bg-[var(--bg-secondary)] rounded-lg">
                            <input type="checkbox" id="privacy-centered-<?php echo esc_attr($this->get_id()); ?>" class="mt-0.5 w-4 h-4 text-[var(--primary)] border-[var(--border-color)] rounded focus:ring-[var(--primary)] cursor-pointer" />
                            <label for="privacy-centered-<?php echo esc_attr($this->get_id()); ?>" class="text-sm text-[var(--text-secondary)] cursor-pointer">
                                <?php echo esc_html($labels['privacy']); ?>
                                <a href="/privacy-policy" target="_blank" rel="noopener noreferrer" class="text-[var(--primary)] hover:opacity-80 underline"><?php echo esc_html($labels['privacyLink']); ?></a>
                                <span class="text-red-500 ml-1">*</span>
                            </label>
                        </div>

                        <button class="w-full flex items-center justify-center gap-2 px-6 py-4 bg-[var(--primary)] text-white font-semibold rounded-lg hover:opacity-90 transition-colors">
                            <?php echo esc_html($submitText); ?>
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/></svg>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
