<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Contact_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_contact_minimal'; }
    public function get_title() { return __('Contact Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-call-to-action'; }
    public function get_categories() { return array('ai-theme-contact'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('email', array('label' => __('Email', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('phone', array('label' => __('Phone', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $this->add_control('address', array('label' => __('Address', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-12 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="contact" data-block-variant="contact-minimal">
            <div class="max-w-2xl mx-auto px-6">
                <h2 class="text-2xl font-bold text-[var(--text-primary)] mb-6"><?php echo esc_html($settings['heading']); ?></h2>
                <div class="space-y-3">
                    <?php if (!empty($settings['email'])) : ?>
                        <p class="flex items-center gap-3 text-[var(--text-secondary)]">
                            <svg class="w-5 h-5 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                            <a href="mailto:<?php echo esc_attr($settings['email']); ?>" class="hover:text-[var(--primary)]"><?php echo esc_html($settings['email']); ?></a>
                        </p>
                    <?php endif; ?>
                    <?php if (!empty($settings['phone'])) : ?>
                        <p class="flex items-center gap-3 text-[var(--text-secondary)]">
                            <svg class="w-5 h-5 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                            <a href="tel:<?php echo esc_attr($settings['phone']); ?>" class="hover:text-[var(--primary)]"><?php echo esc_html($settings['phone']); ?></a>
                        </p>
                    <?php endif; ?>
                    <?php if (!empty($settings['address'])) : ?>
                        <p class="flex items-start gap-3 text-[var(--text-secondary)]">
                            <svg class="w-5 h-5 text-[var(--primary)] mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                            <?php echo nl2br(esc_html($settings['address'])); ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
