<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cookies_Compact extends AI_Widget_Base {
    public function get_name() { return 'ai_cookies_compact'; }
    public function get_title() { return __('Cookies Compact', 'ai-theme'); }
    public function get_icon() { return 'eicon-info-circle'; }
    public function get_categories() { return array('ai-theme-cookies'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('last_updated', array('label' => __('Last Updated', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('introduction', array('label' => __('Introduction', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('contact_email', array('label' => __('Contact Email', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $this->end_controls_section();

        // Cookie Types
        $this->start_controls_section('cookies_section', array('label' => __('Cookie Types', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));

        $cookie_repeater = new Repeater();
        $cookie_repeater->add_control('name', array('label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $cookie_repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $cookie_repeater->add_control('required', array('label' => __('Required', 'ai-theme'), 'type' => Controls_Manager::SWITCHER));

        $this->add_control('cookie_types', array('label' => __('Cookie Types', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $cookie_repeater->get_controls(), 'default' => array()));

        $this->end_controls_section();

        // Sections
        $this->start_controls_section('sections_section', array('label' => __('Sections', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));

        $section_repeater = new Repeater();
        $section_repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $section_repeater->add_control('content', array('label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));

        $this->add_control('sections', array('label' => __('Sections', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $section_repeater->get_controls(), 'default' => array()));

        $this->end_controls_section();

        // Company
        $this->start_controls_section('company_section', array('label' => __('Company Details', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('company_name', array('label' => __('Company Name', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $this->add_control('company_address', array('label' => __('Address', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $has_company = !empty($s['company_name']) || !empty($s['company_address']);

        // Use AI-generated texts with fallbacks
        $t = [
            'updated' => ai_get_text('legal.cookies.lastUpdated', 'Updated'),
            'cookieTypes' => ai_get_text('legal.cookies.typesTitle', 'Cookie Types'),
            'required' => ai_get_text('common.required', 'Required'),
            'optional' => ai_get_text('common.optional', 'Optional'),
            'siteOperator' => ai_get_text('legal.cookies.siteOperator', 'Site Operator'),
            'address' => ai_get_text('common.form.address', 'Address'),
            'contactTitle' => ai_get_text('legal.cookies.contactTitle', 'Questions?'),
            'contactText' => ai_get_text('legal.cookies.contactText', 'Contact us about cookie usage'),
            'contactButton' => ai_get_text('legal.cookies.contactButton', 'Contact Us'),
        ];
        ?>
        <section class="py-16 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cookies" data-block-variant="cookies-compact">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <div class="text-center mb-12">
                    <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-br from-amber-400 to-orange-500 rounded-2xl mb-6 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h1 class="text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($s['heading']); ?></h1>
                    <?php if (!empty($s['last_updated'])) : ?>
                    <p class="text-[var(--text-muted)]"><?php echo esc_html($t['updated']); ?>: <?php echo esc_html($s['last_updated']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Introduction -->
                <?php if (!empty($s['introduction'])) : ?>
                <div class="bg-gradient-to-r from-amber-50 to-orange-50 rounded-2xl p-6 mb-8 border border-amber-100">
                    <p class="text-[var(--text-primary)] leading-relaxed"><?php echo esc_html($s['introduction']); ?></p>
                </div>
                <?php endif; ?>

                <!-- Cookie Types as numbered cards -->
                <?php if (!empty($s['cookie_types'])) : ?>
                <div class="space-y-4 mb-8">
                    <h2 class="text-xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($t['cookieTypes']); ?></h2>
                    <?php foreach ($s['cookie_types'] as $idx => $cookie) :
                        $is_required = !empty($cookie['required']) && $cookie['required'] === 'yes';
                    ?>
                    <article class="bg-[var(--bg-primary)] rounded-2xl p-5 shadow-sm border border-[var(--border-color)]">
                        <div class="flex items-start gap-4">
                            <span class="w-10 h-10 bg-gradient-to-br from-amber-400 to-orange-500 rounded-xl flex items-center justify-center text-white font-bold text-lg flex-shrink-0">
                                <?php echo $idx + 1; ?>
                            </span>
                            <div class="flex-1 min-w-0">
                                <div class="flex items-start justify-between gap-2 mb-2">
                                    <h3 class="font-bold text-[var(--text-primary)]"><?php echo esc_html($cookie['name']); ?></h3>
                                    <span class="text-xs px-3 py-1 rounded-full font-medium flex-shrink-0 <?php echo $is_required ? 'bg-[var(--bg-secondary)] text-[var(--text-secondary)]' : 'bg-green-100 text-green-700'; ?>">
                                        <?php echo esc_html($is_required ? $t['required'] : $t['optional']); ?>
                                    </span>
                                </div>
                                <p class="text-[var(--text-secondary)] text-sm leading-relaxed"><?php echo esc_html($cookie['description']); ?></p>
                            </div>
                        </div>
                    </article>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <!-- Sections as numbered cards -->
                <?php if (!empty($s['sections'])) : ?>
                <div class="space-y-4">
                    <?php $start_num = !empty($s['cookie_types']) ? count($s['cookie_types']) : 0; ?>
                    <?php foreach ($s['sections'] as $idx => $section) : ?>
                    <article class="bg-[var(--bg-primary)] rounded-2xl p-5 shadow-sm border border-[var(--border-color)]">
                        <div class="flex items-start gap-4">
                            <span class="w-10 h-10 bg-gradient-to-br from-amber-400 to-orange-500 rounded-xl flex items-center justify-center text-white font-bold text-lg flex-shrink-0">
                                <?php echo $start_num + $idx + 1; ?>
                            </span>
                            <div class="flex-1">
                                <h3 class="font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($section['title']); ?></h3>
                                <p class="text-[var(--text-secondary)] text-sm leading-relaxed"><?php echo esc_html($section['content']); ?></p>
                            </div>
                        </div>
                    </article>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <!-- Company Details -->
                <?php if ($has_company) : ?>
                <div class="mt-8 bg-[var(--bg-secondary)] rounded-2xl p-6 border border-[var(--border-color)]">
                    <h3 class="font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($t['siteOperator']); ?></h3>
                    <div class="space-y-2 text-[var(--text-secondary)]">
                        <?php if (!empty($s['company_name'])) : ?>
                        <p class="font-medium text-[var(--text-primary)]"><?php echo esc_html($s['company_name']); ?></p>
                        <?php endif; ?>
                        <?php if (!empty($s['company_address'])) : ?>
                        <p><span class="text-[var(--text-muted)]"><?php echo esc_html($t['address']); ?>:</span> <?php echo esc_html($s['company_address']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Contact CTA -->
                <?php if (!empty($s['contact_email'])) : ?>
                <div class="mt-8 bg-gradient-to-r from-amber-500 to-orange-500 rounded-2xl p-6 text-white">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-lg mb-1"><?php echo esc_html($t['contactTitle']); ?></h3>
                            <p class="text-white/80 text-sm"><?php echo esc_html($t['contactText']); ?></p>
                        </div>
                    </div>
                    <a href="mailto:<?php echo esc_attr($s['contact_email']); ?>" class="mt-4 inline-flex items-center gap-2 bg-white text-amber-600 font-semibold px-6 py-3 rounded-xl hover:bg-amber-50 transition-colors">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <?php echo esc_html($t['contactButton']); ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
