<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cookies_Default extends AI_Widget_Base {
    public function get_name() { return 'ai_cookies_default'; }
    public function get_title() { return __('Cookie Policy', 'ai-theme'); }
    public function get_icon() { return 'eicon-info-circle-o'; }
    public function get_categories() { return array('ai-theme-cookies'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', [
            'label' => __('Content', 'ai-theme'),
            'tab' => Controls_Manager::TAB_CONTENT
        ]);

        $this->add_control('heading', [
            'label' => __('Heading', 'ai-theme'),
            'type' => Controls_Manager::TEXT,
            'default' => ''
        ]);

        $this->add_control('last_updated', [
            'label' => __('Last Updated', 'ai-theme'),
            'type' => Controls_Manager::TEXT,
            'default' => ''
        ]);

        $this->add_control('introduction', [
            'label' => __('Introduction', 'ai-theme'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => ''
        ]);

        $this->add_control('contact_email', [
            'label' => __('Contact Email', 'ai-theme'),
            'type' => Controls_Manager::TEXT
        ]);

        $this->end_controls_section();

        // Cookie Types Section
        $this->start_controls_section('cookie_types_section', [
            'label' => __('Cookie Types', 'ai-theme'),
            'tab' => Controls_Manager::TAB_CONTENT
        ]);

        $cookie_repeater = new Repeater();
        $cookie_repeater->add_control('name', [
            'label' => __('Cookie Name', 'ai-theme'),
            'type' => Controls_Manager::TEXT
        ]);
        $cookie_repeater->add_control('description', [
            'label' => __('Description', 'ai-theme'),
            'type' => Controls_Manager::TEXTAREA
        ]);
        $cookie_repeater->add_control('required', [
            'label' => __('Required', 'ai-theme'),
            'type' => Controls_Manager::SWITCHER
        ]);

        $this->add_control('cookie_types', [
            'label' => __('Cookie Types', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $cookie_repeater->get_controls(),
            'default' => [],
            'title_field' => '{{{ name }}}'
        ]);

        $this->end_controls_section();

        // Sections
        $this->start_controls_section('sections_section', [
            'label' => __('Sections', 'ai-theme'),
            'tab' => Controls_Manager::TAB_CONTENT
        ]);

        $section_repeater = new Repeater();
        $section_repeater->add_control('title', [
            'label' => __('Title', 'ai-theme'),
            'type' => Controls_Manager::TEXT
        ]);
        $section_repeater->add_control('content', [
            'label' => __('Content', 'ai-theme'),
            'type' => Controls_Manager::TEXTAREA
        ]);

        $this->add_control('sections', [
            'label' => __('Sections', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $section_repeater->get_controls(),
            'default' => [],
            'title_field' => '{{{ title }}}'
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');

        // Use AI-generated texts with fallbacks
        $t = [
            'updated' => ai_get_text('legal.cookies.lastUpdated', 'Updated'),
            'cookieTypes' => ai_get_text('legal.cookies.typesTitle', 'Cookie Types'),
            'required' => ai_get_text('common.required', 'Required'),
            'optional' => ai_get_text('common.optional', 'Optional'),
            'contactTitle' => ai_get_text('legal.cookies.contactTitle', 'Questions?'),
            'contactText' => ai_get_text('legal.cookies.contactText', 'Contact us about cookie usage'),
            'contactButton' => ai_get_text('legal.cookies.contactButton', 'Contact Us'),
        ];
        ?>
        <section class="py-16 px-4 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cookies" data-block-variant="cookies-default">
            <div class="max-w-4xl mx-auto">
                <!-- Header -->
                <div class="mb-12 text-center">
                    <div class="w-16 h-16 bg-gradient-to-br from-amber-400 to-orange-500 rounded-2xl flex items-center justify-center mx-auto mb-6 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h1 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h1>
                    <?php if (!empty($s['last_updated'])) : ?>
                    <p class="text-[var(--text-muted)]"><?php echo esc_html($t['updated']); ?>: <?php echo esc_html($s['last_updated']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Introduction -->
                <?php if (!empty($s['introduction'])) : ?>
                <div class="mb-10 p-6 bg-gradient-to-r from-amber-50 to-orange-50 rounded-2xl border border-amber-100">
                    <p class="text-[var(--text-primary)] leading-relaxed"><?php echo esc_html($s['introduction']); ?></p>
                </div>
                <?php endif; ?>

                <!-- Cookie Types -->
                <?php if (!empty($s['cookie_types'])) : ?>
                <div class="mb-12">
                    <h2 class="text-2xl font-semibold text-[var(--text-primary)] mb-6"><?php echo esc_html($t['cookieTypes']); ?></h2>
                    <div class="space-y-4">
                        <?php foreach ($s['cookie_types'] as $cookie) : 
                            $is_required = !empty($cookie['required']) && $cookie['required'] === 'yes';
                        ?>
                        <div class="p-5 rounded-2xl border border-[var(--border-color)] bg-[var(--bg-primary)] hover:shadow-md transition-shadow">
                            <div class="flex items-start justify-between mb-2">
                                <h3 class="font-semibold text-[var(--text-primary)]"><?php echo esc_html($cookie['name']); ?></h3>
                                <span class="text-xs px-3 py-1 rounded-full font-medium <?php echo $is_required ? 'bg-[var(--bg-secondary)] text-[var(--text-secondary)]' : 'bg-green-100 text-green-700'; ?>">
                                    <?php echo esc_html($is_required ? $t['required'] : $t['optional']); ?>
                                </span>
                            </div>
                            <p class="text-[var(--text-secondary)] text-sm leading-relaxed"><?php echo esc_html($cookie['description']); ?></p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Sections -->
                <?php if (!empty($s['sections'])) : ?>
                <div class="space-y-8">
                    <?php foreach ($s['sections'] as $idx => $section) : ?>
                    <div class="border-b border-[var(--border-color)] pb-8 last:border-0">
                        <h2 class="text-2xl font-semibold text-[var(--text-primary)] mb-4">
                            <?php echo ($idx + 1) . '. ' . esc_html($section['title']); ?>
                        </h2>
                        <p class="text-[var(--text-secondary)] leading-relaxed"><?php echo esc_html($section['content']); ?></p>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <!-- Contact -->
                <?php if (!empty($s['contact_email'])) : ?>
                <div class="mt-12 bg-gradient-to-r from-amber-500 to-orange-500 rounded-2xl p-6 text-white">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-lg mb-1"><?php echo esc_html($t['contactTitle']); ?></h3>
                            <p class="text-white/80 text-sm"><?php echo esc_html($t['contactText']); ?></p>
                        </div>
                    </div>
                    <a href="mailto:<?php echo esc_attr($s['contact_email']); ?>" class="mt-4 inline-flex items-center gap-2 bg-white text-amber-600 font-semibold px-6 py-3 rounded-xl hover:bg-amber-50 transition-colors">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <?php echo esc_html($t['contactButton']); ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
