<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class FAQ_Gradient extends AI_Widget_Base {
    public function get_name() { return 'ai_faq_gradient'; }
    public function get_title() { return __('FAQ Gradient', 'ai-theme'); }
    public function get_icon() { return 'eicon-accordion'; }
    public function get_categories() { return array('ai-theme-faq'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('question', ['label' => __('Question', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('answer', ['label' => __('Answer', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('faqs', ['label' => __('FAQ Items', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-faq ai-faq-gradient py-16" style="background: linear-gradient(to bottom right, var(--primary-light), var(--secondary-light, var(--primary-light)));" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="faq" data-block-variant="faq-gradient">
            <div class="ai-container-narrow">
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <div class="space-y-4">
                    <?php $idx = 0; foreach ($s['faqs'] as $f) : ?>
                    <div class="ai-faq-item bg-[var(--bg-primary)]/80 backdrop-blur-sm rounded-2xl overflow-hidden border border-[var(--bg-primary)]/50 shadow-lg">
                        <div class="px-6 py-5 flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 rounded-lg flex items-center justify-center flex-shrink-0" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                                    <span class="text-white font-bold text-sm"><?php echo $idx + 1; ?></span>
                                </div>
                                <h3 class="font-semibold text-[var(--text-primary)] text-lg"><?php echo esc_html($f['question']); ?></h3>
                            </div>
                        </div>
                        <div class="px-6 pb-5 bg-[var(--bg-primary)]/30">
                            <div class="text-[var(--text-secondary)] leading-relaxed pl-11 prose prose-sm max-w-none"><?php echo wp_kses_post($f['answer']); ?></div>
                        </div>
                    </div>
                    <?php $idx++; endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
