<?php
/**
 * Features Cards Widget
 *
 * @package AI_Theme
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Features Cards Widget
 */
class Features_Cards extends AI_Widget_Base {

    public function get_name() {
        return 'ai_features_cards';
    }

    public function get_title() {
        return __('Features Cards', 'ai-theme');
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return array('ai-theme-blocks');
    }

    public function get_keywords() {
        return array('features', 'cards', 'services', 'ai');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'ai-theme'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'heading',
            array(
                'label'       => __('Heading', 'ai-theme'),
                'type'        => Controls_Manager::TEXT,
                'default'     => '',
                'label_block' => true,
            )
        );

        $this->add_control(
            'description',
            array(
                'label'   => __('Description', 'ai-theme'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => '',
            )
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            array(
                'label'   => __('Title', 'ai-theme'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            )
        );

        $repeater->add_control(
            'description',
            array(
                'label'   => __('Description', 'ai-theme'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => '',
            )
        );

        $repeater->add_control(
            'icon',
            array(
                'label'   => __('Icon', 'ai-theme'),
                'type'    => Controls_Manager::ICONS,
                'default' => array(
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ),
            )
        );

        $this->add_control(
            'features',
            array(
                'label'   => __('Features', 'ai-theme'),
                'type'    => Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => array(),
            )
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $icons = array(
            '<svg class="w-8 h-8 text-[var(--primary)]" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" /></svg>',
            '<svg class="w-8 h-8 text-[var(--primary)]" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" /></svg>',
            '<svg class="w-8 h-8 text-[var(--primary)]" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>',
            '<svg class="w-8 h-8 text-[var(--primary)]" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" /></svg>',
        );
        ?>
        <section class="ai-features-cards py-16 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="features" data-block-variant="features-cards">
            <div class="max-w-6xl mx-auto px-6">
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h2>
                    <p class="text-lg text-[var(--text-secondary)]"><?php echo esc_html($settings['description']); ?></p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <?php foreach ($settings['features'] as $idx => $feature) : ?>
                        <div class="bg-[var(--bg-primary)] rounded-xl p-6 text-center shadow-sm hover:shadow-md transition-shadow">
                            <div class="mb-4 flex items-center justify-center">
                                <div class="w-16 h-16 mx-auto flex items-center justify-center rounded-full bg-[var(--primary-light)]">
                                    <?php echo $icons[$idx % count($icons)]; ?>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-[var(--text-primary)] mb-2"><?php echo esc_html($feature['title']); ?></h3>
                            <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($feature['description']); ?></p>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
