<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Gallery_Lightbox extends AI_Widget_Base {
    public function get_name() { return 'ai_gallery_lightbox'; }
    public function get_title() { return __('Gallery Lightbox', 'ai-theme'); }
    public function get_icon() { return 'eicon-zoom-in'; }
    public function get_categories() { return array('ai-theme-media'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $this->add_control('images', [
            'label' => __('Images', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $images = $s['images'] ?? [];
        ?>
        <section class="ai-gallery ai-gallery-lightbox bg-[var(--bg-dark)] py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="gallery" data-block-variant="gallery-lightbox">
            <div class="max-w-7xl mx-auto px-6">
                <div class="grid md:grid-cols-3 gap-6">
                    <?php foreach ($images as $idx => $image) : 
                        $img_url = $image['image']['url'] ?? '';
                        $title = $image['title'] ?? '';
                    ?>
                    <div class="group relative overflow-hidden rounded-2xl bg-white/10 aspect-[4/3] cursor-pointer border-2 border-transparent hover:border-white/30 transition-all">
                        <?php if ($img_url) : ?>
                        <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($title ?: 'Gallery image ' . ($idx + 1)); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                        <?php endif; ?>
                        <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                            <div class="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0zM10 7v3m0 0v3m0-3h3m-3 0H7"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
