<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Gallery_Masonry extends AI_Widget_Base {
    public function get_name() { return 'ai_gallery_masonry'; }
    public function get_title() { return __('Gallery Masonry', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-masonry'; }
    public function get_categories() { return array('ai-theme-media'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $this->add_control('images', [
            'label' => __('Images', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $images = $s['images'] ?? [];
        ?>
        <section class="ai-gallery ai-gallery-masonry section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="gallery" data-block-variant="gallery-masonry">
            <div class="max-w-7xl mx-auto px-6">
                <div class="columns-1 md:columns-2 lg:columns-3 gap-6">
                    <?php foreach ($images as $idx => $image) :
                        $img_url = $image['image']['url'] ?? '';
                        $title = $image['title'] ?? '';
                    ?>
                    <div class="mb-6 break-inside-avoid">
                        <div class="group relative overflow-hidden rounded-xl bg-[var(--bg-primary)] cursor-pointer">
                            <?php if ($img_url) : ?>
                            <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($title ?: 'Gallery image ' . ($idx + 1)); ?>" class="w-full group-hover:scale-105 transition-transform duration-300">
                            <?php endif; ?>
                            <?php if ($title) : ?>
                            <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/70 to-transparent p-4 opacity-0 group-hover:opacity-100 transition-opacity">
                                <h3 class="text-white font-bold"><?php echo esc_html($title); ?></h3>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
