<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Gallery_Showcase_Filmstrip extends AI_Widget_Base {
    public function get_name() { return 'ai_gallery_filmstrip'; }
    public function get_title() { return __('Gallery Filmstrip', 'ai-theme'); }
    public function get_icon() { return 'eicon-film-strip'; }
    public function get_categories() { return array('ai-theme-media'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $this->add_control('images', [
            'label' => __('Images', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $images = $s['images'] ?? [];
        ?>
        <section class="ai-gallery ai-gallery-showcase-filmstrip relative w-full bg-[var(--bg-dark)] py-16 overflow-hidden" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="gallery" data-block-variant="gallery-showcase-filmstrip">
            <div class="max-w-7xl mx-auto px-6">
                <div class="overflow-x-auto pb-4" style="scrollbar-width: none; -ms-overflow-style: none;">
                    <div class="flex gap-4">
                        <?php foreach ($images as $idx => $image) : 
                            $img_url = $image['image']['url'] ?? '';
                            $title = $image['title'] ?? '';
                        ?>
                        <div class="flex-shrink-0 group">
                            <div class="relative w-72 aspect-[4/3] bg-black p-1 rounded overflow-hidden">
                                <?php if ($img_url) : ?>
                                <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($title ?: 'Frame ' . ($idx + 1)); ?>" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-105">
                                <?php endif; ?>
                                <?php if ($title) : ?>
                                <div class="absolute inset-0 bg-black/60 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                                    <p class="text-white text-lg font-medium"><?php echo esc_html($title); ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="text-center mt-2 text-white/50 text-xs font-mono">
                                <?php echo str_pad($idx + 1, 2, '0', STR_PAD_LEFT); ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <style>
                div::-webkit-scrollbar { display: none; }
            </style>
        </section>
        <?php
    }
}
