<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Gallery_Showcase_Horizontal extends AI_Widget_Base {
    public function get_name() { return 'ai_gallery_horizontal'; }
    public function get_title() { return __('Gallery Horizontal', 'ai-theme'); }
    public function get_icon() { return 'eicon-slider-push'; }
    public function get_categories() { return array('ai-theme-media'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $repeater = new Repeater();
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('images', [
            'label' => __('Images', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $images = $s['images'] ?? [];
        $widget_id = $this->get_id();
        ?>
        <section class="ai-gallery ai-gallery-showcase-horizontal relative w-full bg-[var(--bg-dark)] py-16 overflow-hidden" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="gallery" data-block-variant="gallery-showcase-horizontal">
            <div class="max-w-7xl mx-auto px-6 mb-8 flex justify-end gap-2">
                <button onclick="scrollGallery<?php echo $widget_id; ?>('left')" class="w-10 h-10 rounded-full border border-white/20 flex items-center justify-center text-white/50 hover:text-white hover:border-white/40 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
                </button>
                <button onclick="scrollGallery<?php echo $widget_id; ?>('right')" class="w-10 h-10 rounded-full border border-white/20 flex items-center justify-center text-white/50 hover:text-white hover:border-white/40 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                </button>
            </div>

            <div id="gallery-scroll-<?php echo $widget_id; ?>" class="flex overflow-x-auto snap-x snap-mandatory pb-8" style="scrollbar-width: none; -ms-overflow-style: none;">
                <div class="flex-shrink-0 w-6"></div>
                <?php foreach ($images as $idx => $image) : 
                    $img_url = $image['image']['url'] ?? '';
                    $title = $image['title'] ?? '';
                    $desc = $image['description'] ?? '';
                ?>
                <div class="flex-shrink-0 snap-center px-3">
                    <div class="group relative w-[80vw] md:w-[60vw] lg:w-[50vw] aspect-[4/3] rounded-2xl overflow-hidden">
                        <?php if ($img_url) : ?>
                        <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($title ?: 'Image ' . ($idx + 1)); ?>" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-105">
                        <?php endif; ?>
                        <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-transparent to-transparent"></div>
                        <?php if ($title) : ?>
                        <div class="absolute bottom-0 left-0 right-0 p-6">
                            <h3 class="text-2xl font-bold text-white"><?php echo esc_html($title); ?></h3>
                            <?php if ($desc) : ?>
                            <p class="text-white/70 text-sm mt-1"><?php echo esc_html($desc); ?></p>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
                <div class="flex-shrink-0 w-6"></div>
            </div>

            <div class="flex justify-center gap-2 mt-4">
                <?php foreach ($images as $idx => $image) : ?>
                <div class="w-2 h-2 rounded-full bg-white/30"></div>
                <?php endforeach; ?>
            </div>

            <script>
            function scrollGallery<?php echo $widget_id; ?>(direction) {
                const container = document.getElementById('gallery-scroll-<?php echo $widget_id; ?>');
                const scrollAmount = container.offsetWidth * 0.6;
                container.scrollBy({
                    left: direction === 'left' ? -scrollAmount : scrollAmount,
                    behavior: 'smooth'
                });
            }
            </script>
            <style>
                #gallery-scroll-<?php echo $widget_id; ?>::-webkit-scrollbar { display: none; }
            </style>
        </section>
        <?php
    }
}
