<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Map_With_Info extends AI_Widget_Base {
    public function get_name() { return 'ai_map_with_info'; }
    public function get_title() { return __('Map With Info', 'ai-theme'); }
    public function get_icon() { return 'eicon-google-maps'; }
    public function get_categories() { return array('ai-theme-map'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('address', ['label' => __('Address', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('phone', ['label' => __('Phone', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('email', ['label' => __('Email', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('hours', ['label' => __('Business Hours', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('embed_url', ['label' => __('Embed URL', 'ai-theme'), 'type' => Controls_Manager::URL]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-map ai-map-with-info w-full section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="map" data-block-variant="map-with-info">
            <div class="ai-container">
                <?php if (!empty($s['title'])) : ?>
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <?php endif; ?>
                <div class="bg-[var(--bg-primary)] rounded-2xl overflow-hidden shadow-xl grid grid-cols-1 lg:grid-cols-2">
                    <div class="ai-map-info p-8 md:p-12 bg-[var(--primary-light)]">
                        <div class="space-y-6">
                            <?php if (!empty($s['address'])) : ?>
                            <div class="flex items-start gap-4">
                                <div class="flex-shrink-0 w-12 h-12 bg-[var(--primary)] rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                </div>
                                <div>
                                    <h3 class="text-sm font-semibold text-[var(--text-primary)] mb-1 uppercase tracking-wide"><?php _e('Address', 'ai-theme'); ?></h3>
                                    <p class="ai-map-address text-[var(--text-secondary)]"><?php echo nl2br(esc_html($s['address'])); ?></p>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if (!empty($s['phone'])) : ?>
                            <div class="flex items-start gap-4">
                                <div class="flex-shrink-0 w-12 h-12 bg-[var(--primary)] rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                                </div>
                                <div>
                                    <h3 class="text-sm font-semibold text-[var(--text-primary)] mb-1 uppercase tracking-wide"><?php _e('Phone', 'ai-theme'); ?></h3>
                                    <p class="ai-map-phone"><a href="tel:<?php echo esc_attr($s['phone']); ?>" class="text-[var(--primary)] hover:underline"><?php echo esc_html($s['phone']); ?></a></p>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if (!empty($s['email'])) : ?>
                            <div class="flex items-start gap-4">
                                <div class="flex-shrink-0 w-12 h-12 bg-[var(--primary)] rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                                </div>
                                <div>
                                    <h3 class="text-sm font-semibold text-[var(--text-primary)] mb-1 uppercase tracking-wide"><?php _e('Email', 'ai-theme'); ?></h3>
                                    <p class="ai-map-email"><a href="mailto:<?php echo esc_attr($s['email']); ?>" class="text-[var(--primary)] hover:underline"><?php echo esc_html($s['email']); ?></a></p>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if (!empty($s['hours'])) : ?>
                            <div class="flex items-start gap-4">
                                <div class="flex-shrink-0 w-12 h-12 bg-[var(--primary)] rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                </div>
                                <div>
                                    <h3 class="text-sm font-semibold text-[var(--text-primary)] mb-2 uppercase tracking-wide"><?php _e('Business Hours', 'ai-theme'); ?></h3>
                                    <div class="ai-map-hours space-y-1 text-sm text-[var(--text-secondary)]"><?php echo nl2br(esc_html($s['hours'])); ?></div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if (!empty($s['embed_url']['url'])) : ?>
                    <div class="ai-map-container h-full min-h-[500px]">
                        <iframe src="<?php echo esc_url($s['embed_url']['url']); ?>" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" title="Map with Info" class="w-full h-full"></iframe>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
