<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Privacy_Sidebar extends AI_Widget_Base {
    public function get_name() { return 'ai_privacy_sidebar'; }
    public function get_title() { return __('Privacy Sidebar', 'ai-theme'); }
    public function get_icon() { return 'eicon-document-file'; }
    public function get_categories() { return array('ai-theme-privacy'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('last_updated', array('label' => __('Last Updated', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('introduction', array('label' => __('Introduction', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('contact_email', array('label' => __('Contact Email', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('content', array('label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG, 'default' => ''));

        $this->add_control('sections', array('label' => __('Sections', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();

        $this->start_controls_section('company_section', array('label' => __('Company Details', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('company_name', array('label' => __('Company Name', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $this->add_control('company_address', array('label' => __('Address', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $this->add_control('company_inn', array('label' => __('INN', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $this->add_control('company_ogrn', array('label' => __('OGRN', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $has_company = !empty($settings['company_name']) || !empty($settings['company_address']);

        // Localized texts
        $t = [
            'updated' => ai_get_text('legal.updated', 'Updated:'),
            'data_controller' => ai_get_text('privacy.dataController', 'Data Controller'),
            'address' => ai_get_text('common.address', 'Address:'),
            'tax_id' => ai_get_text('privacy.taxId', 'Tax ID:'),
            'registration' => ai_get_text('privacy.registration', 'Registration:'),
            'questions' => ai_get_text('privacy.questionsShort', 'Questions?'),
            'contact_about' => ai_get_text('privacy.contactAbout', 'Contact us about personal data processing'),
            'contact_us' => ai_get_text('common.contactUs', 'Contact Us'),
        ];
        ?>
        <section class="py-16 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="privacy" data-block-variant="privacy-sidebar">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <div class="text-center mb-12">
                    <div class="inline-flex items-center justify-center w-16 h-16 rounded-2xl mb-6 shadow-lg" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                    </div>
                    <h1 class="text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($settings['heading']); ?></h1>
                    <?php if (!empty($settings['last_updated'])) : ?>
                    <p class="text-[var(--text-muted)]"><?php echo esc_html($t['updated']); ?> <?php echo esc_html($settings['last_updated']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Introduction -->
                <?php if (!empty($settings['introduction'])) : ?>
                <div class="bg-[var(--primary-light,#dbeafe)] rounded-2xl p-6 mb-8 border border-[var(--border-color)]">
                    <p class="text-[var(--text-primary)] leading-relaxed"><?php echo esc_html($settings['introduction']); ?></p>
                </div>
                <?php endif; ?>

                <!-- Sections -->
                <div class="space-y-6">
                    <?php foreach ($settings['sections'] as $idx => $section) : ?>
                    <article class="bg-[var(--bg-primary)] rounded-2xl p-6 shadow-sm border border-[var(--border-color)]">
                        <div class="flex items-start gap-4 mb-4">
                            <span class="w-10 h-10 rounded-xl flex items-center justify-center text-white font-bold text-lg flex-shrink-0" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                                <?php echo $idx + 1; ?>
                            </span>
                            <h2 class="text-xl font-bold text-[var(--text-primary)] pt-1.5"><?php echo esc_html($section['title']); ?></h2>
                        </div>
                        <div class="text-[var(--text-secondary)] leading-relaxed pl-14 prose prose-sm max-w-none">
                            <?php echo wp_kses_post($section['content']); ?>
                        </div>
                    </article>
                    <?php endforeach; ?>
                </div>

                <!-- Company Details -->
                <?php if ($has_company) : ?>
                <div class="mt-8 bg-[var(--bg-secondary)] rounded-2xl p-6 border border-[var(--border-color)]">
                    <h3 class="font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($t['data_controller']); ?></h3>
                    <div class="space-y-2 text-[var(--text-secondary)]">
                        <?php if (!empty($settings['company_name'])) : ?>
                        <p class="font-medium text-[var(--text-primary)]"><?php echo esc_html($settings['company_name']); ?></p>
                        <?php endif; ?>
                        <?php if (!empty($settings['company_address'])) : ?>
                        <p><span class="text-[var(--text-muted)]"><?php echo esc_html($t['address']); ?></span> <?php echo esc_html($settings['company_address']); ?></p>
                        <?php endif; ?>
                        <?php if (!empty($settings['company_inn'])) : ?>
                        <p><span class="text-[var(--text-muted)]"><?php echo esc_html($t['tax_id']); ?></span> <?php echo esc_html($settings['company_inn']); ?></p>
                        <?php endif; ?>
                        <?php if (!empty($settings['company_ogrn'])) : ?>
                        <p><span class="text-[var(--text-muted)]"><?php echo esc_html($t['registration']); ?></span> <?php echo esc_html($settings['company_ogrn']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Contact CTA -->
                <?php if (!empty($settings['contact_email'])) : ?>
                <div class="mt-8 rounded-2xl p-6 text-white" style="background: linear-gradient(to right, var(--primary), var(--secondary));">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-lg mb-1"><?php echo esc_html($t['questions']); ?></h3>
                            <p class="text-white/80 text-sm"><?php echo esc_html($t['contact_about']); ?></p>
                        </div>
                    </div>
                    <a href="mailto:<?php echo esc_attr($settings['contact_email']); ?>" class="mt-4 inline-flex items-center gap-2 bg-white text-[var(--primary)] font-semibold px-6 py-3 rounded-xl hover:bg-white/90 transition-colors">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <?php echo esc_html($t['contact_us']); ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
