<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Reviews_List extends AI_Widget_Base {
    public function get_name() { return 'ai_reviews_list'; }
    public function get_title() { return __('Reviews List', 'ai-theme'); }
    public function get_icon() { return 'eicon-review'; }
    public function get_categories() { return array('ai-theme-reviews'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('average_rating', ['label' => __('Average Rating', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('total_reviews', ['label' => __('Total Reviews', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $repeater = new Repeater();
        $repeater->add_control('author', ['label' => __('Author', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('avatar', ['label' => __('Avatar', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('rating', ['label' => __('Rating (1-5)', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'min' => 1, 'max' => 5]);
        $repeater->add_control('date', ['label' => __('Date', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('reviews', ['label' => __('Reviews', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <div class="ai-reviews ai-reviews-list w-full section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="reviews" data-block-variant="reviews-list">
            <div class="ai-container-narrow">
                <!-- Header and Average Rating -->
                <div class="mb-12">
                    <div class="ai-reviews-header flex items-start justify-between mb-6">
                        <div>
                            <h2 class="text-3xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($s['title']); ?></h2>
                        </div>
                    </div>

                    <!-- Overall Statistics -->
                    <?php if (!empty($s['average_rating'])) : ?>
                    <div class="ai-reviews-summary bg-[var(--bg-secondary)] rounded-xl p-6 flex items-center gap-8">
                        <div class="text-center">
                            <div class="ai-reviews-average text-5xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($s['average_rating']); ?></div>
                            <?php if (!empty($s['total_reviews'])) : ?>
                            <p class="ai-reviews-count text-sm text-[var(--text-secondary)]"><?php echo esc_html($s['total_reviews'] . '+ ' . ai_get_text('reviews.reviewsCount', __('reviews', 'ai-theme'))); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Reviews List -->
                <div class="ai-reviews-items space-y-6 mb-12">
                    <?php foreach ($s['reviews'] as $r) : ?>
                    <div class="ai-review-item bg-[var(--bg-primary)] border border-[var(--border-color,#e5e7eb)] rounded-xl p-6 hover:shadow-md transition-shadow">
                        <!-- Author and Rating -->
                        <div class="ai-review-header flex items-start gap-4 mb-4">
                            <!-- Avatar -->
                            <?php if (!empty($r['avatar']['url'])) : ?>
                            <div class="w-12 h-12 rounded-full overflow-hidden bg-[var(--bg-secondary)] flex-shrink-0">
                                <img src="<?php echo esc_url($r['avatar']['url']); ?>" alt="<?php echo esc_attr($r['author']); ?>" class="ai-review-avatar w-full h-full object-cover">
                            </div>
                            <?php endif; ?>

                            <div class="ai-review-meta flex-1">
                                <div class="flex items-center justify-between mb-2">
                                    <div>
                                        <h4 class="font-semibold text-[var(--text-primary)]"><?php echo esc_html($r['author']); ?></h4>
                                        <?php if (!empty($r['date'])) : ?>
                                        <p class="ai-review-date text-sm text-[var(--text-muted)]"><?php echo esc_html($r['date']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Rating Stars -->
                                <?php if (!empty($r['rating'])) : ?>
                                <div class="ai-review-rating flex items-center gap-1 mb-3">
                                    <?php for ($i = 1; $i <= 5; $i++) : ?>
                                    <span class="<?php echo $i <= $r['rating'] ? 'text-yellow-400' : 'text-[var(--text-muted)]'; ?>">★</span>
                                    <?php endfor; ?>
                                </div>
                                <?php endif; ?>

                                <!-- Review Content -->
                                <p class="ai-review-content text-[var(--text-secondary)] leading-relaxed"><?php echo esc_html($r['content']); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
    }
}
